function [element] = vb_display_factor_get_element(obj, number)
% vb_display_factor_get_element returns specified element
% [USAGE]
%    [element] = vb_display_factor_get_element(<obj>);
% [IN]
%       obj : display_factor object
%    number : element number
% [OUT]
%    element : display_element object
%
% Author: rhayashi
% Created: 2007-08-08
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('number', 'var'), error('number is a required parameter.'); end
if (vb_display_factor_get_length(obj) < number) || (number <= 0)
    error('specified number is invalid.');
end

%
% --- Main Procedure
%
element = obj.element_cell{number};
