function   [avw] = convert_nifti_to_las(fname,fnout)
% Convert nifti file to LAS Analyze file
% --- Usage
%   convert_nifti_to_las(fname,fnout);
% --- Input
% fname : Input NIFTI file namw
% fnout : Output Analyze file name
%
% Made by Masa-aki Sato 2010-1-10
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% Load NIFTI header & image
avw = load_nii_cbi(fname);

%  Check NIFTI format
if ~isfield(avw,'filetype') || avw.filetype == 0
	error('File is not Nifti-format');
end

% Change to RAS
avw = change_orient_ras(avw);

hdr = avw.hdr;
img = avw.img;
dim = size(img);

% flip to LAS
img(1:dim(1),:,:) = img(dim(1):-1:1,:,:);


avw.img = img;

avw.hdr.dime.dim    = hdr.dime.dim;
avw.hdr.dime.pixdim = hdr.dime.pixdim;

% --- Save as analyze format
avw.hdr.hist.orient = 0;
avw.hdr.hist.originator = zeros(size(avw.hdr.hist.originator));

avw.hdr.hist.qform_code  = 0;
avw.hdr.hist.sform_code  = 0;

avw.hdr.hist.quatern_b   = 0;
avw.hdr.hist.quatern_c   = 0;
avw.hdr.hist.quatern_d   = 0;
avw.hdr.hist.qoffset_x   = 0;
avw.hdr.hist.qoffset_y   = 0;
avw.hdr.hist.qoffset_z   = 0;

avw.hdr.hist.srow_x = [- avw.hdr.hist.srow_x(1:3) 0];
avw.hdr.hist.srow_y = [avw.hdr.hist.srow_y(1:3) 0];
avw.hdr.hist.srow_z = [avw.hdr.hist.srow_z(1:3) 0];

% NIFTI Magic string must be either "ni1" or "n+1";
% Not NIFTI Magic string
avw.hist.magic = 'aaa';
avw.filetype = 0;

if nargin==2 && ~isempty(fnout)
	% Save as analyze format
	save_nii_ana(avw, fnout);
end
