function	[RASout] = convert_dicom_nifti(dicom_file,output_dir)
% Convert DICOM to NIFTI file for VBMEG.
% --- Usage 1
%  convert_dicom_nifti;
%   GUI mode. select one of DICOM file.
%   NIfTI file will be created in the DICOM directory.
% --- Usage 2
%  RASout = convert_dicom_nifti(dicom_file, output_dir)
%  [Input]
%      dicom_file : set one of dicom files.
%      output_dir : output directory for NIfTI file.
%  [Output]
%    RASout : created NIfTI file path.
%
% [Note]
%   NIfTI file is :  data order : RAS
%                        origin : ceter of the image.
% [History]
%  Masa-aki Sato 2010-01-10
%       rhayashi 2010-05-13 supported not reorienting case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

RASout  = []; % RASname with path

% path for 'dcm2niix' program 
prog_path = [];

% select DICOM directory
if ~exist('dicom_file','var'), 
	[this] = file_dialog;
    this.dialog_title = 'Select one of DICOM files';
	[dicom_dir, dicom_file] = visible(this);
    if length(dicom_file) == 0, return; end
	dicom_file = [dicom_dir filesep dicom_file{1}];
else
	[dicom_dir, fname, fext] = vb_get_file_parts(dicom_file);
end

if ~exist('output_dir','var') || isempty(output_dir)
	output_dir = dicom_dir; 
end
h = msgbox('Now converting...');

disp('============================================');
disp('DICOM to RAS NIfTI file(.nii)');
disp('Start converting...');

% --- Convert DICOM to NIFTI file by 'dcm2niix'
[status, nifti_filename] = convert_dicom_nifti_cmd(dicom_file, output_dir, prog_path);
nifti_file = fullfile(output_dir, nifti_filename);

% Convert original NIfTI to RAS NIfti(origin: ceter of the image)
RASout = fullfile(output_dir, filesep, ['RAS_' nifti_filename]);
convert_nifti_to_ras(nifti_file, RASout);
fprintf('Saved RAS NIfTI file: %s\n', RASout);

delete(nifti_file);

disp('Finished converting.');
disp('============================================');

if ishandle(h)
    delete(h);
end

return

