function   convert_analyze_las(fname, fnout, orient_now)
%  Change orientation of analyze file image
%    convert_analyze_las(fname, fnout, orient_now)
% --- Input
% fname : input  Analyze file
% fnout : output Analyze file
% orient_now : orient number of current image
% --- orient_now
% orient_now   = [orient_now_x  orient_now_y  orient_now_z]
% orient_now_x : current x-axis orient number defined below
% orient_now_y : current y-axis orient number defined below
% orient_now_z : current z-axis orient number defined below
% --- orient number
% Left to Right           1 [R]  % Right to Left          -1 [L]
% Posterior to Anterior   2 [A]  % Anterior to Posterior  -2 [P]
% Inferior to Superior    3 [S]  % Superior to Inferior   -3 [I]
%
% Made by Masa-aki Sato 2008-02-17
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

avw = avw_img_read(fname);

avw = change_orient_analyze(avw, orient_now);

avw_img_write(avw, fnout);
