function xx = lcd_generate_data(conMAR, u, xx0) 
% GENERATE DATA GIVEN MAR MODEL AND INPUTS
%
% [Input]
%   conMAR : concatenated MAR coeffient matrix [Nv Nvxdmax]
%    u     : input vectors [Nv Nt]
% [Optional Inputs]
%   xx0    : initial values [Nv, dmax] 
%           if not given, zero vectors are assumed.
% [Output]
%   xx   : simulated data   [Nv Nt]
%
% 2017/12/20 O.Yamashita

[Nv1,Ncol] = size(conMAR);
dmax = Ncol/Nv1;  % maximum delay
[Nv2,Nt] = size(u);

if Nv1 ~= Nv2, error('incosistent matrix size, conMAR or u !'); end

if nargin < 3
    xx0 = zeros(Nv1, dmax);
end

% 
x = [xx0 zeros(Nv1,Nt)];
for tt = dmax+1 : Nt+dmax
    tt;
    x0 = x(:,tt-1:-1:tt-dmax);   
    x(:,tt) = conMAR*x0(:)+u(:,tt-dmax);
end

xx = x(:,dmax+1:end);