function [A,B,Lam,Sig]=lcd_fitl2reg_holocalAR(Zact,Delta,p,lambda, localfactor)
% MAR parameter estimate with l2 reguralization for higher order local AR
% model (holocalAR model)
%
% * higher order local AR model 
%  j(v,t) = sum_p a(v,p)*j(v,t-p) + sum_u b(v,u)*j(u,t-Delta(v,u)) + epsilon(t)
% 
% [Input] 
% Zact :  current waveforms [Nv Nt]
% Delta : delay matrix (sparse) with unit of time points 
%         (i.e. all the elements must be integer representing dicrete time
%         points)
%   p    : AR order for local dynamics 
% lambda : a regularization parameter common to all the vertices
%          if set [], optimal lambda is computed for each vertex  
% localfactor : if specified, local regularization parameter is lambda*localfactor 
% 
% [Output]
%  A  : diagonal parts of MAR matrix (local dynamics)  [Nv,p]
%  B  : non-digonal parts of MAR matrix (distant interactions) [Nv Nv]
%
% 2016/05/09 O.Yamashita
% * avoid increasing memory allocation
% * allow for multiple lambdas
% 2016/04/11 O.Yamashita 
% 2016/01/29 O.Yamashita 

if nargin < 5
    localfactor = [];
end


[Nv,Nt] = size(Zact);
Dmax = max(Delta(:));
Dmax = max([Dmax,p]);

if isempty(lambda) | length(lambda) == 1
    B = zeros(Nv,Nv);
    A = zeros(Nv,p);
else
    B = zeros(Nv,Nv,length(lambda));
    A = zeros(Nv,p,length(lambda));
end


for vv = 1 : Nv
    
    fprintf('process %04d ...\n',vv);
    
    y = [Zact(vv,Dmax+1:Nt)]';
    
    dvec = round(Delta(vv,:));
    iv = setdiff(find(dvec ~= 0), vv); % other than self loop
    
    % define X 
    X = zeros(Nt-Dmax, length(iv)+p);
    for aa = 1 : p
    X(:,aa) = Zact(vv,Dmax+1-aa:Nt-aa)';
    end
    nn = p+1;
    for uu = iv
        X(:,nn) = Zact(uu,Dmax+1-dvec(uu):Nt-dvec(uu))';
        nn = nn + 1;
    end
    
    % weighted reguralization for local model
    w = ones(size(X,2),1);
    if ~isempty(localfactor)
        w(1:p) = localfactor;
    end
    
    
    if isempty(lambda) | length(lambda) == 1
        [lam,sig,val,a] = wmn_solution(y,X,[],[],struct('flag_plot',0,'lambda',lambda));
        A(vv,:) = a(1:p);    
        B(vv,iv) = a(p+1:end);
        Lam(vv) = lam;
        Sig(vv) = sig;
    else
        [aa] = wmn_solution_fixreg(y, X, [], [], lambda, struct('flag_plot',0));
        A(vv,:,:) = aa(1:p,1,:);
        B(vv,iv,:) = aa(p+1:end,1,:);
        Lam = lambda;
        Sig = [];
    end
    
    
    
    
    
end

 






