function conMAR=lcd_ab2conmar(A,B,Delta,fuflag)
% AB FORMS TO CONCATENATED MAR MATRIX
% 
% [Input]
%  A : MAR coefficient for self node   [Nv p]
%  B : MAR coefficients from other nodes [Nv Nv]
% Delta : delay matrix (unit:time point) [Nv Nv]
% fuflag : if 1, Fukushima-MAR model is used 
%
% [Output]
% conMAR : concatenated MAR matrix [Nv Nv*Dmax]
%
% 2016/04/13 O.Yamashita
% * [Bugfix] wrong diagonal components of Fu-MAR are corrected.
% 2016/01/28 O.Yamashita

if nargin < 4
    fuflag = 0;
end

[Nv,Np] = size(A);
Dmax = max(max(Delta(:)),Np);
% form transition matrix
conMAR = zeros(Nv,Nv,Dmax);
for uu = 1 : Nv
    % nondiagonal part
    for vv = 1 : Nv
        if Delta(uu,vv) ~= 0 & uu ~= vv
        conMAR(uu,vv,Delta(uu,vv)) = B(uu,vv);
        end
    end
    % diagonal part
    if fuflag
        conMAR(uu,uu,Delta(uu,uu)) = A(uu,1);
    else
        for aa = 1 : Np
            conMAR(uu,uu,aa) = A(uu,aa);
        end
    end
end
conMAR = reshape(conMAR,[Nv Nv*Dmax]);
conMAR = sparse(conMAR); 


