%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

root = 'data';

% Input files
fiber_tracking_file   = '~/dynamics_movie/Vmni_connect.mat';
movie_current_file    = fullfile(root, '/dynamics/input_for_movie/a.mat';

% load current info
load(movie_current_file, 'sampling_rate', 'time')

% Output files - movie file(.avi)
output_dir = '~/dynamics_movie';
movie_right_file  = fullfile(output_dir, '/right_view.avi');
movie_left_file   = fullfile(output_dir, '/left_view.avi');
movie_bottom_file = fullfile(output_dir, '/bottom_view.avi');
movie_top_file    = fullfile(output_dir, '/top_view.avi');
movie_file        = fullfile(output_dir, '/movie.avi');

% movie create
time_of_first_sample = time(1)*1000; % first sample of time([msec])

view_type = 'LT'; % Left/Top
title_str = 'Subject-task';

switch view_type
    case 'LB'     % Left/Bottom
        movie_left_view_create(fiber_tracking_file, movie_current_file, movie_left_file, time_of_first_sample, sampling_rate);
        movie_bottom_view_create(fiber_tracking_file, movie_current_file, movie_bottom_file, time_of_first_sample, sampling_rate);
        left_side_file  = movie_left_file;
        right_side_file = movie_bottom_file;
        left_is_left = false;
    case 'LT'     % Left/Top
        movie_left_view_create(fiber_tracking_file, movie_current_file, movie_left_file, time_of_first_sample, sampling_rate);
        movie_top_view_create(fiber_tracking_file, movie_current_file, movie_top_file, time_of_first_sample, sampling_rate);
        left_side_file  = movie_left_file;
        right_side_file = movie_top_file;
        left_is_left = true;
    case 'RB'     % Right/Bottom
        movie_right_view_create(fiber_tracking_file, movie_current_file,  movie_right_file, time_of_first_sample, sampling_rate);
        movie_bottom_view_create(fiber_tracking_file, movie_current_file, movie_bottom_file, time_of_first_sample, sampling_rate);
        left_side_file  = movie_right_file;
        right_side_file = movie_bottom_file;
        left_is_left = false;
    case 'RT'     % Right/Top
        movie_right_view_create(fiber_tracking_file, movie_current_file,  movie_right_file, time_of_first_sample, sampling_rate);
        movie_top_view_create(fiber_tracking_file, movie_current_file, movie_top_file, time_of_first_sample, sampling_rate);
        left_side_file  = movie_right_file;
        right_side_file = movie_top_file;
        left_is_left = true;
    otherwise
        error('Unknown view type is specified.');
end

%
% --- combine movies
%

% left_is_left % set to true when you make top view movie.
movie_combine(left_side_file, right_side_file, movie_file, title_str, left_is_left);
