function	[B, Xdim, Ydim] = overwite_mask(B,mask,indx,cutdim,val,rgb)
% overwite mask on MRI slice
% [B, Xdim, Ydim] = overwite_mask(B,mask,indx,cutdim,val,rgb)
%           
%  B        selected 2D slice image (3rd-dim is color dim) by
%           [B, Xdim, Ydim] = select_slice(img,indx,cutdim);
%  mask     3D image of mask
%  indx     slice index to show
%  cutdim   slice cut direction {'x' 'y' 'z'}
%  val      mask value to show (N x 1)
%  rgb      RGB value for each mask value (N x 3))
%           
%  B        selected 2D slice image with overlapped mask
%  Xdim     
%  Ydim     
%
%  	image(Xdim, Ydim, B, 'CDataMapping','scaled');
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Selected image slice
dim = size(B);

% Select mask slice
[B2, Xdim, Ydim] = select_slice(mask,indx,cutdim);

% B2: RGB color matrix (3rd-dim is color dim)
% Back to original slice value by transpose of 2D matrix
B2 = B2(:,:,1)';

Nval = length(val);

if size(rgb,1) == 1, rgb = repmat(rgb, [Nval 1]); end

for n=1:Nval
	% find voxel (2D subscript) with specified mask value
	[ix,jx] = find(B2 == val(n));
	
	for m = 1:3
		% transpose of 2D matrix (ix <-> jx) for image plot
		% Get index for 3D array
		jj = sub2ind(dim, jx, ix, repmat( m , [length(ix) 1]));
		B(jj) = rgb(n,m); % RGB
	end
end	
