function	[dY,dZ] = make_orthogonal_vec(dX)
% make orthogonal vector to dX in 3D space 
%  [dY,dZ] = make_orthogonal_vec(dX)
% dY & dZ is orthogonal to dX and consist 2D-axis of orthogonal plane
%  dX , dY , dZ: [N x 3]
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[N, d] = size(dX);
if d ~= 3, error('data dimension error'); end

dY = zeros(N, d);
dZ = zeros(N, d);

%% Zero vector check
xx = sum(dX.^2, 2);
%ix = find( xx > 0);
%
%dx = dX(ix,:);
%xx = sqrt(xx(ix));
%N  = size(dx,1);

% reference vector
e1 = [ones(N,1), zeros(N,2)];
e2 = [zeros(N,1), ones(N,1), zeros(N,1)];

% normalization
dX  = vb_repmultiply(dX, 1./xx);

% make orthogonal vector to dx by cross product
dy1 = vb_cross2(dX,e1);
dy2 = vb_cross2(dX,e2);
% norm of dy1 & dy2
dyy1 = sqrt(sum(dy1.^2, 2));
dyy2 = sqrt(sum(dy2.^2, 2));

% select vector with larger norm
[tmp, jx] = max([dyy1, dyy2],[],2);

ix1 = find( jx == 1);
ix2 = find( jx == 2);

% dy : orthogonal vector to dx
dy = zeros(N,3);
dy(ix1,:) = dy1(ix1,:);
dy(ix2,:) = dy2(ix2,:);

% normalization
dyy = sqrt(sum(dy.^2, 2));
dY  = vb_repmultiply(dy, 1./dyy);

% dY & dZ is orthogonal to dX and consist 2D-axis of orthogonal plane
% dx,dy,dz make right-hand coordinate
dz = vb_cross2(dX,dy);

% normalization
dzz = sqrt(sum(dz.^2, 2));
dZ  = vb_repmultiply(dz, 1./dzz);

%dY(ix,:) = dy;
%dZ(ix,:) = dz;

return
%--------------- END -----------------
% check right-hand coordinate
dyz = vb_cross2(dy,dz);
XYZ = sum(dx.*dyz, 2);

ix = find(XYZ < 0);

dz(ix,:) = - dz(ix,:);

if ~isempty(ix)
	fprintf('# of reversed direction=%d\n',length(ix))
end

DEBUG = 0;

% check
if DEBUG == 1
	dxerr = sum(abs(sqrt(sum(dX.^2, 2)) - 1))
	dyerr = sum(abs(sqrt(sum(dY.^2, 2)) - 1))
	dyerr = sum(abs(sqrt(sum(dZ.^2, 2)) - 1))
	
	xyerr = sum(abs(sum(dX.*dY,2)))
	yzerr = sum(abs(sum(dY.*dZ,2)))
	zxerr = sum(abs(sum(dZ.*dX,2)))
end
