function	[V] = load_connection(d, p);
% V{n} : vertex 3D coordinate for n-th connections
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% number of connections
NP = size(d.Vmni_from,2);

% skip selection for connections
V_from = d.Vmni_from(:,1:p.Nskip:NP);
V_to   = d.Vmni_to(:,1:p.Nskip:NP);

% number of connections to show
NL = size(V_to,2);

% divide V_from - V_to into inner points
pdev = (1:p.Ndivide)'/p.Ndivide;

X = pdev * V_to(1,:) + (1 - pdev) * V_from(1,:);
Y = pdev * V_to(2,:) + (1 - pdev) * V_from(2,:);
Z = pdev * V_to(3,:) + (1 - pdev) * V_from(3,:);


V = cell(NL,1);% vertex coordinate for connections

for n=1:NL
	V{n} = [X(:,n),Y(:,n),Z(:,n)];
end
