function	[Jpred, Index_orig, omega] = load_ar_dynamics_icbm(arfile, input)
% load AR dynamics parameter and make currebt prediction
%
% [Jpred, Vindex, input] = load_ar_dynamics_icbm(arfile, input)
%
% 2015-5-25 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load(arfile,'MAR','Delta','omega','Index_orig')

if nargin==2
	omega = input;
end

% Predicted currents (Output of the system with the input 'omega')
[Jpred] = forward_prediction(MAR, Delta, omega);

% Index_orig correspond to Jpred
