function	[Xpath, Npath] = get_shortest_path(parm, facefile)
% get_shortest_path along head
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Face surface
face = load(facefile);
V = face.Vspm;
F = face.F;
xx = face.xx;

% Pair channel
ix_from = parm.probe_pair(:, 1);
ix_to   = parm.probe_pair(:, 2);

src_pos = parm.src_pos(ix_from, :);
det_pos = parm.det_pos(ix_to, :);

% Map start(X1) & end(X2) points on surface
[Indx ,derr] = vb_find_nearest_point(V,src_pos);
X1 = V(Indx,:);
xx1 = xx(Indx,:);

[Indx ,derr] = vb_find_nearest_point(V,det_pos);
X2 = V(Indx,:);
xx2 = xx(Indx,:);

% Maximum edge length of surface patch
xxD = vb_next_distance(F,V);
% xxD{n} : ĺ n  ܶ˵ Ȥ Υ
dmax = max(vb_cell_merge(xxD));

%
% ----- shortest path from source to detector
%
Npair = size(src_pos,1);
Xpath = cell(Npair,1);
Npath = zeros(Npair,1);

for k=1:Npair
    V1 = X1(k,:); % source 
    V2 = X2(k,:); % detector
    xn = (xx1(k,:) + xx2(k,:))/2; % mean normal direction
    
    % Find the shortest path from V1 to V2 along surface
    % The plane is defined by (V2 - V1) & the normal direction 'xn'
    % The path is cross section of surface and plane
    Vpath = plane_cross_section(V,F,V1,V2,xn,dmax);
    Xpath{k} = Vpath;
    Npath(k) = size(Vpath,1);
end

