function C = cmap_add(cmap1,cmap2,add_mode)
% add two colormap
%  C = cmap_add(cmap1,cmap2,add_mode)
%    returns colormap matrix
%  cmap_add(cmap1,cmap2,add_mode)
%    set colormap
% --- Input
% cmap1 : colormap 1 [N1 x 3]
% cmap2 : colormap 2 [N2 x 3]
% add_mode : normalization mode
%       =0 : if RGB value > 1, it is set to 1
%       =0 : if RGB value > 1, each [R,G,B] is normalized by max value
% 
% --- Output
% C : colormap matrix ([R G B] matix) : [NtotalLevel x 3]
%
% Masa-aki Sato 2014-10-30
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if size(cmap1,2) ~= 3, error('Color must be 3 vector'); end;
if size(cmap2,2) ~= 3, error('Color must be 3 vector'); end;

N1 = size(cmap1,1);
N2 = size(cmap2,1);

if N1==N2
	C = cmap1 + cmap2;
elseif N1 > N2
	C = cmap1 + [cmap2; zeros(N1-N2,3)];
else
	C = cmap2 + [cmap1; zeros(N2-N1,3)];
end

switch	add_mode
case	0
	C = min(C,1);
case	1
	Cmax = max(C);
	Cmax = max(Cmax,1);
	
	C = vb_repmultiply(C, 1./Cmax);
end

if nargout==0
	colormap(C);
end
