function	[V, Nc] = cell_to_mat(Vc)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if iscell(Vc),
	NC = length(Vc);
	Nc = zeros(NC,1);
	
	for n=1:NC
		Nc(n) = size(Vc{n},1);
	end
	
	Npoint = sum(Nc);
	V = zeros(Npoint, size(Vc{1},2));
	jst = 0;
	
	for n=1:NC
		j1 = jst+1;
		j2 = jst+Nc(n);
		V(j1:j2,:) = Vc{n};
		jst = jst + Nc(n);
	end
else
	V  = Vc;
	Nc = size(V,1);
end
