function disp_brain_model_make(vmni_connect_file, brain_file, area_file, data_area_file)
% Create data_area_file
% [Input]
%    vmni_connect_file : [input file]  Vmni_connect.mat       : Fiber tracking file.
%           brain_file : [input file]  VBMEG BRAIN-MAT file   : Subject.brain.mat
%            area_file : [input file]  VBMEG AREA-MAT file    : Subject.area.mat
%
%       data_area_file : [output file] data_area_file
%
% [See]
%    make_conn_data.m : To make Vmni_connect.mat file.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin ~= 4
    error('Please check function usage.');
end
%
% --- Previous check
%
if exist(vmni_connect_file, 'file') ~= 2
    error('vmni_connect_file not found.');
end
if exist(brain_file, 'file') ~= 2
    error('brain_file not found.');
end
if exist(area_file, 'file') ~= 2
    error('area_file not found.');
end

%
% --- Main Procedure
%
out_dir   = fileparts(data_area_file);

atlas_dir = [fileparts(which('ch2.img')), filesep];

% Connection pair index file
conn_file = vmni_connect_file;

brainfile = brain_file;
areafile  = area_file;

% output directory creation
if exist(out_dir, 'dir') ~= 7
    mkdir(out_dir);
end

%------- File parameter
%--- atras file
parm.atlas_text = [atlas_dir 'aal.txt'];
parm.atlas_file = [atlas_dir 'aal.img'];
parm.atlasimage = [atlas_dir 'ch2.img'];
parm.atlasbrain = which('ch2_pial.brain.mat');

% Brain file
parm.brainfile = brainfile;
parm.areafile  = areafile;
parm.conn_file = conn_file;

%--- Minimum vertex number for area selection
parm.Nmin = 10;
%--- If keyfile is specified, ROI area is loaded from keyfile
parm.keyfile = [];
%parm.keyfile = 'key_list2.txt';
%parm.keyfile = 'key_list.txt';

%--- output file
parm.data_area = data_area_file;

%--- morphology radius for brain surface smoothing
parm.RadiusA = [-3 3];  % for ROI area
parm.RadiusB = [+3];  % for brain

%--- brain surface data
% Data_area.V0 : Vertices on MNI coordinate
% Data_area.F0 : Faces
% Data_area.FL : Faces(Left brain)
% Data_area.FR : Faces(Right brain)
%--- area key to display
% Data_area.key  : area name list       {cell array}
% Data_area.cmap : color list for areas [n x 3]
%--- surfaces for area key to display
% Data_area.V  : areas vertices         {cell array}
% Data_area.F  : areas Faces            {cell array}

Data_area = make_area_surf(parm);

fprintf('make_area_surf done\n\n')

if isfield(parm,'data_area') && ~isempty(parm.data_area)
	save(parm.data_area,'Data_area')
end
