#!/bin/bash
# Make transfomation field (nonlinear)
#
# 2012/06/21 M.Fukushima
# 2012/06/25 M.Fukushima
# 2012/11/30 M.Fukushima
# 2013/02/11 M.Fukushima
#
# Copyright (C) 2011, ATR All Rights Reserved.
# License : New BSD License(see VBMEG_LICENSE.txt)

if [ $# -ne 4 ]
then
	echo 'make_transwarp.sh FS_DIR T1_BRAIN_GZ_FILE FA_GZ_FILE OUTPUT_DIR'
	exit 1
fi

# FreeSurfer directory
FS_DIR=$1

# T1 NIfTI-GZ file which contains only brain part.
T1_BRAIN_GZ_FILE=$2

# FA nifti gz file
FA_GZ_FILE=$3

# Output directory
OUTPUT_DIR=$4

# temporary directory
TEMP_DIR="${OUTPUT_DIR}/tmp"

if [ ! -d "$OUTPUT_DIR" ]
then
    mkdir $OUTPUT_DIR
fi
if [ ! -d "$TEMP_DIR" ]
then
    mkdir $TEMP_DIR
fi

mri_convert $FS_DIR/mri/brain.mgz $FS_DIR/mri/brain.nii.gz

echo "# Transformation matrix from FreeSurfer-space <=> T1-space"
# Transfomation matrix from FreeSurfer-space to T1-space
tkregister2 --mov $FS_DIR/mri/orig.mgz --targ $FS_DIR/mri/rawavg.mgz --regheader --reg $TEMP_DIR/junk --fslregout $OUTPUT_DIR/freesurfer2struct.mat --noedit
# Inverse matrix
convert_xfm -omat $OUTPUT_DIR/struct2freesurfer.mat -inverse $OUTPUT_DIR/freesurfer2struct.mat

echo "# Transformation matrix from T1-space <=> Diffusion space"
# Transfomation matrix from T1-space to Diffusion-space (linear)
flirt -in $FA_GZ_FILE -ref $T1_BRAIN_GZ_FILE -omat $OUTPUT_DIR/fa2struct.mat -cost normmi
# Transformation field from T1-space to Diffusion-space (nonlinear)
fnirt --in=$FA_GZ_FILE --ref=$T1_BRAIN_GZ_FILE --aff=$OUTPUT_DIR/fa2struct.mat --cout=$OUTPUT_DIR/fa2struct_warp.nii.gz
# Inverse
invwarp -w $OUTPUT_DIR/fa2struct_warp.nii.gz -o $OUTPUT_DIR/struct2fa_warp.nii.gz -r $FA_GZ_FILE

echo "# Transformation matrix from FreeSurfer-space <=> Diffusion-space"
# Transfomation matrix from Diffusion-space to FreeSurfer-space (concatenation)
convertwarp -o $OUTPUT_DIR/fa2freesurfer_warp.nii.gz -r $FS_DIR/mri/brain.nii.gz -w $OUTPUT_DIR/fa2struct_warp.nii.gz --postmat=$OUTPUT_DIR/struct2freesurfer.mat
# Transfomation matrix from FreeSurfer-space to Diffusion-space (concatenation)
convertwarp -o $OUTPUT_DIR/freesurfer2fa_warp.nii.gz -r $FA_GZ_FILE -m $OUTPUT_DIR/freesurfer2struct.mat -w $OUTPUT_DIR/struct2fa_warp.nii.gz
echo "Done."