function [membershipmat] = make_membershipmat(brainfile, parcelsfile)
% Make a binary matrix that indicates parcel labels of brain model(~20000 vertices).
%
% Input:
%  brainfile =   'Subject.brain.mat';
%  parcelsfile = 'parcels.mat';
%
% Output:
%  membershipmat [~1840 x ~20000]
%   A binary matrix that indicates parcel labels of brain model(~20000 vertices) (e.g., 
%   membershipmat(2,3) = 1 means that the vertex #3 in brain.mat is included
%   in the parcel #2 in parcels.mat).
%
% 2015/01/29 M.Fukushima
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[tmp1, tmp2, BV_index, Vinfo] = vb_load_cortex_info(brainfile, 'subj');
load(parcelsfile,'lh_cortex_id','rh_cortex_id')

label_l = zeros(length(BV_index.Left),1);

for ii = 1:length(BV_index.Left)
  for jj = 1:length(lh_cortex_id)
    if sum(BV_index.Left(ii)==lh_cortex_id{jj})
      label_l(ii) = jj;
    end
  end
end

label_r = zeros(length(BV_index.Right),1);
BV_index_Right_tmp = BV_index.Right - Vinfo.NdipoleL0;

for ii = 1:length(BV_index.Right)
  for jj = 1:length(rh_cortex_id)
    if sum(BV_index_Right_tmp(ii)==rh_cortex_id{jj})
      label_r(ii) = jj;
    end
  end
end
label_r(label_r~=0) = label_r(label_r~=0) + length(lh_cortex_id);

label = [label_l; label_r;];

Nvact = length(lh_cortex_id) + length(rh_cortex_id);
membershipmat = sparse(Nvact, length(label));
for ii = 1:Nvact
  membershipmat(ii,label==ii) = 1;
end
