function [mcoord] = get_mask_coordinate(vfile, qfile, Nx, Ny, Nz)
% Get mm coordinates of mask voxels
% Input
%  vfile: Ascii voxel image file made by 'fsl2ascii'
%  qfile: Ascii qform values from 'fslorient -getqform > (filename)'
%  Nx, Ny, Nz: Numbers of voxels in MRI
% Output
%  mcoord: mm coodinate of all the voxels in the mask image
%
% 2012/06/13 M.Fukushima
% 2013/08/03 M.Fukushima
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Load 0/1 ascii image
vimage = load(vfile,'ascii');
[indyz,indx] = find(vimage==1);
indy = mod(indyz,Ny);
indz = (indyz - indy)/Ny + 1;

% 1-base -> 0-base
indx = indx - 1;
indy = indy - 1;
indz = indz - 1;
% Voxel coordinate
vcoord = [indx indy indz];

% Load qform matrix
qform = load(qfile,'-ascii');
qform = reshape(qform,[4,4])';

% mm coordinate
mcoord = (qform(1:3,1:3)*vcoord' + repmat(qform(1:3,4),[1 size(indx,1)]))';
