function is_cover_all = dmri_parcels_cover_all_vertices(parcel_file, ...
                                                        brain_file, ...
                                                        fs_info_file)
% Check if there are vertices that are not affiliated with either parcels.
%
% [Usage]
%    is_cover_all = dmri_parcels_cover_all_vertices(parcel_file, ...
%                                                   brain_file, ...
%                                                   fs_info_file);
% 
% [Input]
%     parcel_file : parcels information file.
%      brain_file : VBMEG Cortical model file.
%    fs_info_file : Freesurfer infomation file.
%
% [Output]
%    is_cover_all : = true  : All the vertices are affilated with either parcels.
%                   = false : There are vertices that are not affilateed with 
%                             either parcels.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin ~= 3
    error('Please check input arguments.');
end
if exist(parcel_file, 'file') ~= 2
    error('Specified parcel_file not found.');
end
if exist(brain_file, 'file') ~= 2
    error('Specified brain_file not found.');
end
if exist(fs_info_file, 'file') ~= 2
    error('Specified fs_info_file not found.');
end

%
% --- Main Procedure
%

load(parcel_file);
load(fs_info_file);

warning('off', 'MATLAB:load:variableNotFound')
load(brain_file, 'subj');
warning('on', 'MATLAB:load:variableNotFound')
if exist('subj', 'var')
    % for VBMEG ver2 BRAIN-MAT
    Vinfo       = subj.Vinfo;
    normal_stat = subj.normal_stat;
else
    % for VBMEG ver1 BRAIN-MAT
    load(brain_file, 'Vinfo', 'normal_stat');
end

tt=[];

tt = [tt FS_wm.lh_subcortex_index];
for ii = 1:length(lh_cortex_id)
  tt = [tt lh_cortex_id{ii}];
end

tt = [tt FS_wm.rh_subcortex_index+Vinfo.NdipoleL0];
for ii = 1:length(rh_cortex_id)
  tt = [tt rh_cortex_id{ii}+Vinfo.NdipoleL0];
end

is_cover_all = false;
Nfsv = size(normal_stat.normal_org,1);
if (min(tt)==1)&&(max(tt)==Nfsv)&&(length(unique(tt))==Nfsv)
  is_cover_all = true;
end
