function dmri_process_fodf_calc(p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

%
% --- Get area for response function estimation
%
fa_file        = fullfile(p.output_dir, p.dwi_dirname, [p.FA_basename, '.nii.gz']);
resp_area_file = fullfile(p.output_dir, p.fiber_track_dirname, p.fiber_resp_area_file);

dmri_response_estimation_prepare(fa_file, resp_area_file);


%
% --- Calculate fiber orientation density function.
%
dwi_file                = fullfile(p.output_dir, p.dwi_dirname, [p.dwi_basename, '_m.nii.gz']);
bval_file               = fullfile(p.output_dir, p.dwi_dirname, [p.dwi_basename, '_m.bval']);
bvec_file               = fullfile(p.output_dir, p.dwi_dirname, [p.dwi_basename, '_m.bvec']);
struct_brain_on_fa_file = fullfile(p.output_dir, p.dwi_dirname, [p.t1_brain_basename, '_brain_FA.nii.gz']);
output_mif_file         = fullfile(p.output_dir, p.fiber_track_dirname, p.fiber_mif_file);

dmri_fodf_calc(dwi_file, bval_file, bvec_file, ...
               resp_area_file, struct_brain_on_fa_file, output_mif_file);


%
% --- Check result
%

% Check1
cmd = ['fslview ', struct_brain_on_fa_file, ' ', resp_area_file, ' -l Blue'];
dmri_system(cmd);

% Check2
% dmri_mrview(fa_file);
