function dmri_process_cortex_parcel(p)
% 
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

if isfield(p, 'parcel_method') && strcmpi(p.parcel_method, 'area')
   if isfield(p,'ref_parcel_area_file') && ~isempty(p.ref_parcel_area_file)
       parcel_area_file = p.ref_parcel_area_file;
   else
       parcel_area_file = fullfile(p.output_dir, p.vbmeg_dirname, [p.vbmeg_cortex_basename, '_aal.area.mat']);
   end
else
    parcel_area_file = '';
    Nvertex = 2000;
end

if isfield(p, 'ref_brain_file') && ~isempty(p.ref_brain_file)
    brain_file = p.ref_brain_file;
else
    brain_file = fullfile(p.output_dir, p.vbmeg_dirname, [p.vbmeg_cortex_basename, '.brain.mat']);
end

if isfield(p, 'ref_fs_dir') && ~isempty(p.ref_fs_dir)
    fs_dir = p.ref_fs_dir;
else
    fs_dir = fullfile(p.output_dir, p.fs_dirname, p.fs_sbj_name);
end

output_dir   = fullfile(p.output_dir, p.vbmeg_dirname);

%
% --- Read FreeSurfer information
%
fs_info_file = fullfile(output_dir, 'fs_info', 'fs_info.mat');
dmri_fs_info_read(fs_dir, fs_info_file);

%
% --- Create parcels
%
parcel_file  = fullfile(output_dir, p.parcels_file);
if isempty(parcel_area_file)
    dmri_cortex_parcel(brain_file, fs_info_file, Nvertex, parcel_file);
else
    dmri_cortex_parcel_from_area(brain_file, fs_info_file, parcel_area_file, parcel_file);
end
