function dmri_process_connection_calc(p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

parcels_file       = fullfile(p.output_dir, p.vbmeg_dirname, p.parcels_file);
parcel_dir         = fullfile(p.output_dir, p.parcels_dirname);
anat_matrix_file   = fullfile(p.output_dir, p.fiber_track_dirname, p.anat_matrix_file);
dmri_file          = fullfile(p.output_dir, p.connectivity_dirname, p.dmri_file);
%
% --- Calculate connectiviy matrix and create diffusion MRI file
%
dmri_connect_parm_calc(parcels_file, parcel_dir, anat_matrix_file, dmri_file);

%
% --- Show connectivity on brain
%
if isfield(p, 'ref_brain_file') && ~isempty(p.ref_brain_file)
    brain_file = p.ref_brain_file;
else
    brain_file = fullfile(p.output_dir, p.vbmeg_dirname, [p.vbmeg_cortex_basename, '.brain.mat']);
end
if isfield(p, 'ref_aal_area_file') && ~isempty(p.ref_aal_area_file)
    area_file = p.ref_aal_area_file;
else
    area_file = fullfile(p.output_dir, p.vbmeg_dirname, [p.vbmeg_cortex_basename, '_aal.area.mat']);
end
dmri_plot_dmri_connections_on_brain(dmri_file, brain_file, area_file);
dmri_plot_dmri_connections_matrix(dmri_file, brain_file, area_file);
