function dmri_process_T1_bias_correct(p)
% Apply bias correction to T1 image.
% Bias corrected image filename is 'm' + original T1 image.
% [Usage]
%    dmri_process_analyze_bias_correct(p);
% [Input]
%    p : dmri process parameter
%     .output_dir          : output directory.
%     .t1_dirname          : T1 data directory name.
%     .t1_file             : T1 filename.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

%
% --- Previous check
%
if isfield(p, 'ref_mri_file') && ~isempty(p.ref_mri_file)
    warning('Bias correction for T1-image step is skipped because p.ref_mri_file is specified.');
    return;
end

%
% --- Apply Bias correction to T1 image.
%
mri_file = fullfile(p.output_dir, p.t1_dirname, p.t1_file);
vb_bias_correction_by_spm(mri_file);
