function dmri_transwarp_info_create(freesurfer_dir, ...
                                    t1_brain_gz_file, ...
                                    fa_gz_file, ...
                                    output_dir)
% create transformation info between T1-space, Difusion space and FreeSurfer space.
% [Usage]
%    dmri_transwarp_info_create(freesurfer_dir, t1_brain_gz_file,
%                               fa_gz_file, output_dir);
% [Input]
%      freesurfer_dir : FreeSurfer single subject directory.
%    t1_brain_gz_file : T1 nifti-gz file(.nii.gz) which contains only brain part.
%          fa_gz_file : FA nifti-gz file(.nii.gz) Fractional Anisotropy image.
%
% [Output]
%    none
%
% [Example]
%    freesurfer_dir   = '/home/cbi-data4/rhayashi/te1-face/freesurfer/Sub08';
%    t1_brain_gz_file = '/home/cbi-data4/rhayashi/te1-face/t1/Sub08/nifti_gz/struct_brain.nii.gz';
%          fa_gz_file = '/home/cbi-data4/rhayashi/te1-face/fsl/Sub08/data_FA.nii.gz';
%          output_dir = '/home/cbi-data4/rhayashi/te1-face/fsl/Sub08/xfm/rot_mod';
%
%    dmri_transwarp_info_create(freesurfer_dir, t1_brain_gz_file, fa_gz_file, output_dir);
%
%  Example output files.
%    /home/cbi-data4/rhayashi/te1-face/fsl/Sub08/xfm/rot_mod
%         fa2freesurfer_warp.nii.gz
%         fa2strict_warp.nii.gz
%         freeesurfer2fa_warp.nii.gz
%         struct2fa_warp.nii.gz
%
%         fa2struct.mat
%         freesurfer2struct.mat
%         struct2freesurfer.mat
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin ~= 4
    error('Please check input argument.');
end
if exist(freesurfer_dir, 'dir') ~= 7
    error('Specified FreeSurfer directory not found.');
end
if exist(t1_brain_gz_file, 'file') ~= 2
    error('Specified t1 brain image file not found.');
end
if exist(fa_gz_file, 'file') ~= 2
    error('Specified Fractional Anisotropy image file not found.');
end
if exist(output_dir, 'dir') ~= 7
    mkdir(output_dir);
    if exist(output_dir, 'dir') ~= 7
        error('Cannot create output directory.');
    end
end

%
% --- Main Procedure
%
disp('Creating transformation info between T1-space, Difusion-space and FreeSurfer-space.');
start = tic;
trans_cmd = which('make_transwarp.sh');
cmd = ['chmod 755 ', trans_cmd];
system(cmd);
command = [trans_cmd ' ', freesurfer_dir,   ' ', ...
                          t1_brain_gz_file, ' ', ...
                          fa_gz_file,        ' ', ...
                          output_dir];
[status, cmdout] = dmri_system(command, '-echo');
if status ~= 0
    error('Please check input arguments');
end
toc(start);

