function	vb_save_atlas_label(areafile,xxP,label,key,LR)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%%%
%%% Generate an area file with anatomical atlas division 
%%%

if ~exist('LR','var'), LR = []; end;

% Save area label into area file

Nlabel = length(label);

if exist(areafile,'file'),
  load(areafile,'MRI_ID');
else
	[fname, MRI_ID] = vb_change_file_basename(areafile,[]);
end

for l = 1 : Nlabel
    ind = find(xxP == label(l));  %% index of region which has label(l)   
    Area.Iextract = ind;      
    Area.key = [key{l} LR];

    if ~isempty(ind)
    	vb_add_area(areafile, Area, MRI_ID, OFF);
    end
end
