function	[Nvert,Npart,name] = vb_find_atlas_label_number(atlasfile,brainfile)
% 
%   [Mvert,Npart,name] = vb_find_atlas_label_number(atlasfile,brainfile)
% --- Input
% atlasfile,
% brainfile
% --- Output
% Mvert{n} : # of vertex in n-th label
% Npart(n) : # of connected area in n-th label
% name{n}  : area name of n-th label
% 
% 2009-10-12 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% load brain
[V, F] = vb_load_cortex(brainfile);

F	 = F.F3;		% patch index
NV   = size(V,1);	% # of vertex

load(atlasfile)
Act = Act{1};

name  = Act.label_name;
label = Act.label      ; % label value;
Narea = length(label);

% label value for each vertex [Nvertex x 1]
xxP   = Act.xxP; 

Npart = zeros(Narea+1,1);
Nvert = cell(Narea+1,1);
Nvert{Narea+1} = sum( xxP == 0 );
name{Narea+1}  = 'Non_area';
Npart(Narea+1) = 1;

for n=1:Narea
    % vertex index for n-th label
    ix = find( xxP == label(n) );
    
    if isempty(ix), continue; end;
    
    % find connected region
	[Vindx, Nall] = vb_connected_vertex(ix,F);
	
	% set label to largest connected region
	if ~isempty(Vindx)
		Npart(n) = length(Nall);
		Nvert{n} = Nall;
	end
	
end

return

Nmax = max(Npart);
Mvert = zeros(Narea+1,Nmax);

for n=1:Narea+1
	if Npart(n) > 0
		Mvert(n,1:Npart(n)) = Nvert{n};
	end
end
