function [XYZmni, XYZtal] = vb_calc_mni_coord_fs(parm)
% Transform coordinate of vertex points on an individual brain to those on the MNI starndard brain. 
% MNI coordinate as well as Talairach coordinate corresponding to 'V' are
% returned. This routine requires FreeSurfer sphere files.
% 
% [Usage]
%   [XYZmni , XYZtal] = vb_calc_mni_coord_fs(parm);
%
% [Input]
%  Fields in 'parm' struct
%            brain_file : Subject Cortical model file(.brain.mat)
%  FS_right_sphere_file : Subject FreeSurfer right sphere file(.sphere.reg.asc)
%   FS_left_sphere_file : Subject FreeSurfer left  sphere file(.sphere.reg.asc)
%         FS_sphere_key : Registration key of sphere coordinate value to brain_file.
% 
% [Output]
%    XYZmni  : MNI coordinate  (unit:m)       [Nveretex * 3]
%    XYZtal  : Talairach coordinate (unit:m)  [Nveretex * 3]
%
% [History]
%   2013-01-25 rhayashi Copy and modified vb_calc_mni_coord.m
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Cortical model file contains cortex and sphere coordinate
% which is made from ICBM152c Template image.
global vbmeg_inst;
brain_file_template = vbmeg_inst.const.FILE_MNI_ICBM152_BRAIN;

%
% --- Sphere coregistration between template and subject cortical file
%
[d, f, e] = vb_get_file_parts(parm.brain_file);
proj_root = d;
brain_parm.brain_file = [f, e];
brain_parm.brain_sphR = parm.FS_right_sphere_file;
brain_parm.brain_sphL = parm.FS_left_sphere_file;
brain_parm.key        = parm.FS_sphere_key;
vb_job_brain_add_sphcoord(proj_root, brain_parm);

% Map template-coordinate to subject cortex
XYZmni = inner_calc_mni_coord(brain_file_template, parm);

% mni2tal : MNI to Talairach coordinate transformation
XYZtal = mni2tal(XYZmni);

return;

function XYZmni = inner_calc_mni_coord(brain_file_template, parm)
% [IN]
%    brain_file_template : template brain file.
%                   parm : same as caller function's.
% [OUT]
%    XYZmni : MNI coordinate


% --- load coordinates of cortical models
V1_sph = vb_load_cortex(brain_file_template, 'sphere.reg');
V2_sph = vb_load_cortex(parm.brain_file,     parm.FS_sphere_key);
T_mni  = vb_load_cortex(brain_file_template, 'MNI');

load(brain_file_template, 'Vinfo');
IL1 = Vinfo.NdipoleL;
load(parm.brain_file,      'Vinfo');
IL2 = Vinfo.NdipoleL;

V1_sph(1:IL1,1) = V1_sph(1:IL1,1)-400;
V2_sph(1:IL2,1) = V2_sph(1:IL2,1)-400;

% --- obtain nearest vertex for each of sbj_test vertices
ix = [];
I  = size(V1_sph,1);

for i=1:size(V2_sph,1)
  d         = sum((repmat(V2_sph(i,:),[I 1])-V1_sph).^2,2);
  [tmp,ixx] = min(d);
  ix        = [ix; ixx];
end

XYZmni = T_mni(ix,:);

return;
