function	vb_atlas2vb_std_aal(parm)
% vb_atlas2vb create an areafile based on the anatomical atlas
% 
% ---- Syntax
% vb_atlas2vb_std_aal(parm)
%
% ---- Input (Field names in 'parm')
% atlas_id   : ID of atlas.
% atlas_text : atlas label name text file 
% atlas_file : atlas image file 
% save_areafile  : Area file saved
% save_atlasfile : Atlas file saved
% brainfile      : brain file;
%
% --- Function required  
%  explode      : string manupilation 
%
% ---- NOTE -----
% When using the normalize transformation matrix created by 'spm99',  
% back transformation results with a little shift 
% toward X(Left-Right) direction compared with brain file.
% It is highly recommended to recalculate 
% the transformation matrix by spm2 !!!
%
% 2005/03/03 OY
% 2005/03/28 modified 
% 2005/04/21 second part modified
% 2005/09/09 ver.030b compatible
% 2005/12/22 M.Sato
% 2006/2/3   M.Sato
% 2006/11/14 M.Sato
% 2007/03/05 OY
% * MNI coordinate is stored in brainfile.
% * save_xyzfile is removed.
% * A label for 'Corpus' is NaN.
% 2009-01-05 Taku Yoshioka
%   Supression of confirmation dialog
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% ---- Define aal-atlas
%

% Max value corresponding to Cerebrum cortex region in aal-atlas
%  1-90: Cerebrum, 91-108: Cerebellum, 109-116: Vermis
MaxLabel   = 90;	

atlas_dir  = parm.atlas_dir;
atlas_id   = 'aal';
atlas_text = [atlas_dir 'aal.txt'];
atlas_file = [atlas_dir 'aal.img'];

brainfile  = parm.brainfile;

save_areafile  = parm.save_areafile;
save_atlasfile = parm.save_atlasfile;

% In the 1st-step, nearest point is searched within Rmax
% In the 2nd-step, nearest point is searched for all candidates
% This value determine, efficiency of search,
% but does not change the result

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% Don't modify %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Template file is neurological format (right handed spm).

% Standard brain cortex in MNI-mm coordinate (origin in MNI-space)
load(brainfile,'V','F')

NL = F.NdipoleL;
NP = size(V,1);
Vlabel	 = zeros(NP,1);

% Read atlas-template image 
% Zlabel - label for 3D image data (label value)
% XYZmm0 - 3 x n matrix of XYZ locations 
%          mm-coordinates in atlas-template (origin : AC-PC center)

avw = avw_img_read(atlas_file);
Zlabel = avw.img;

% Read image-header
[dim, Trans] = vb_get_image_info(atlas_file);

% convert to standard voxcel coordinate from mm-coordinate
Vox = [V*1000 ones(NP,1)] * inv(Trans');
Vox = round(Vox(:,1:3));

% Extract labeled left/right region
mni_L = sub2ind(dim, ...
        Vox(1:NL,1),Vox(1:NL,2),Vox(1:NL,3));
mni_R = sub2ind(dim, ...
        Vox(1+NL:end,1),Vox(1+NL:end,2),Vox(1+NL:end,3));

%
% ---- Left brain (Left label is odd integer in 'aal')
%
label_L = Zlabel(mni_L);
ixz  = find( mod( label_L, 2 ) == 0 | label_L > MaxLabel);
label_L(ixz) = 0;
%
% ---- Right brain (Right label is even integer in 'aal')
%
label_R = Zlabel(mni_R);
ixz  = find( mod( label_R, 2 ) == 1 | label_R > MaxLabel);
label_R(ixz) = 0;

fprintf('--- Mapping Atlas-label onto 2D cortical surface \n');

%
% ---- Save labeled area
%
Nlabel_L = sum( label_L ~= 0 );	% # of labeled points
Nlabel_R = sum( label_R ~= 0 );	% # of labeled points

fprintf('# of all vertex     = %d\n',NP)
fprintf('# of labeled points = %d\n',Nlabel_L+Nlabel_R)

% Read atlas text file and extract area keys.
[label, label_name] = vb_read_atlas_label(atlas_text);

% Save area label into area file
fprintf('Save the area file as "%s" \n', save_areafile);

Vlabel(1:NL) = label_L;
Vlabel(1+NL:end) = label_R;

vb_save_atlas_label(save_areafile,Vlabel,label,label_name);

% Intensity of 'Act.xxP' is the label for each vertex
Atlas.key = [atlas_id];
Atlas.xxP = Vlabel;
Atlas.label      = label;
Atlas.label_name = label_name;

% Save label as actfile
fprintf('Save the atlas file as "%s"  \n', save_atlasfile);
vb_add_act(save_atlasfile,Atlas,[],false);


%clear Zlabel Vlabel XYZmm0 XYZmm Zlabel
