function parm = vb_set_preprocess_meg3_parm
% Reject noisy sensors and trials, and divide trials according to
% experimental conditions in division file. If division file
% (divfile) was not specified, MEG data will not be divided.
% If parm was not specified, recommended values will be used.
%
% Input parameters (recommended value)
% - parm.th_eog_v  : Threshold for EOG signal in vertical direction
%                    (0.75)
% - parm.th_eog_h  : Threshold for EOG signal in horizontal
%                    direction (0.75)
% - parm.th_meg    : Threshold for noise in MEG data (8)
% - parm.meg_coef  : Threshold for power of MEG data considered as
%                    a candidate of rejected sensor (5.0)
% - parm.Ntrial_th : The number of trials over which MEG time
%                    courses exhibit noise on the same sensor (5)
% - parm.rm_trial  : It can be used to directly specify trials to
%                    be rejected.
% - parm.verify    : If it is ON (constant), the script shows
%                    trials that should be rejected and the user
%                    must verify each trial by clicking 'OK' button
%                    on a dialog (ON).
% - parm.freq      : MEG data frequency.
% - parm.driftremovalmode
%                  : 'linear' -- remove drift with linear fitting.
%                  : 'guodra' -- remove drift with quodra fitting.
%                  : 'sin' -- remove drift with sin-cos fitting.
% - parm.basiocycle: when parm.driftrimovalmode = 'sin', you need
%                    specify this parameter as vector of
%                    basio-cycles, for example parm.basiocycle =
%                    [4,8,16,32] (second). It is recomended that
%                    basiocycle > trial time length.
% - parm.baseline_pretrig
%                  : If this parameter is ON, baseline correction
%                    by using median of MEG data at pretrigger
%                    period for each sensor.
% - parm.jobmode   : Select jobs and order of that in this
%                    preprocessing.
%                    NOTICE that the result of preprocessing would
%                    be changed if you specify the order of jobs.
%                    The following (default) order is recomended.
%                    1 -- Reject dead sensors
%                    2 -- Remove drift and correct baseline
%                    3 -- Remove trials in which EOG signal exceeds
%                         a threshold.
%                    4 -- Reject sensors on which MEG time courses
%                         of some trials are noisy.
%                    5 -- Reject noisy trials
% 2004-12-28 Taku Yoshioka
% 2005-08-16 Taku Yoshioka
% 2006-06-14 Dai Kawawaki
%---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

parm.jobmode = [1,2,3,4,5];

parm.divfile = [''];
parm.megfile = [''];

%parm.num_eog_channels = 2;
%parm.eog_channel_id = [211 212];
%parm.th_eog     = [0.75 0.75];
%parm.th_meg     = 8;
%parm.meg_coef   = 5;
%parm.Ntrial_th  = 5;
%parm.rm_trial   = [];
%parm.verify     = ON;

parm.freq       = 1000;
parm.driftremovalmode = 'sin';
parm.basiocycle = [4,8,16,32];%if parm.driftremovalmode = 'sin'
parm.baseline_pretrig = ON;

return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function parm = set_default_preprocess_parm

parm.num_eog_channels = 2;
parm.eog_channel_id = [211 212];
parm.th_eog     = [0.75 0.75];
parm.th_eog_v   = 0.75;
parm.th_eog_h   = 0.75;
parm.th_meg     = 8;
parm.meg_coef   = 5.0;
parm.Ntrial_th  = 5;
parm.rm_trial   = [];
parm.verify     = ON;

return

