function	brain_parm = vb_set_freesurfer_file(fs_dir,mode_reg,brain_parm)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% fs_dir: Root dir for freesurfer

if nargin < 2, mode_reg = 'fs'; end;
if nargin < 3, brain_parm = []; end;

% FreeSurfer file
brain_parm.FS_left_file         = [fs_dir '/bem/lh.smoothwm.asc'];
brain_parm.FS_right_file        = [fs_dir '/bem/rh.smoothwm.asc'];
brain_parm.FS_left_infl_file    = [fs_dir '/bem/lh.inflated.asc'];
brain_parm.FS_right_infl_file   = [fs_dir '/bem/rh.inflated.asc'];
brain_parm.FS_left_curv_file    = [fs_dir '/bem/lh.curv.asc'];
brain_parm.FS_right_curv_file   = [fs_dir '/bem/rh.curv.asc'];

brain_parm.FS_left_label_file  = [fs_dir '/label/lh.cortex.label'];
brain_parm.FS_right_label_file = [fs_dir '/label/rh.cortex.label'];

switch	mode_reg
case	'fs'
	brain_parm.FS_left_sphere_file  = [fs_dir '/bem/lh.sphere.reg.asc'];
	brain_parm.FS_right_sphere_file = [fs_dir '/bem/rh.sphere.reg.asc'];
	
	brain_parm.FS_sphere_key = 'sphere.reg';
	brain_parm.registration_mode='FS';
end

