function bayes_parm = vb_set_bayes_default_parameters(bayes_parm)
% Set default value for bayes prior and estimation parameters
%
% --- Syntax
% bayes_parm = vb_set_bayes_default_parameters;
% bayes_parm = vb_set_bayes_default_parameters(bayes_parm);
%
% --- History
% 2008-11-05 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%% --- Iteration number
bayes_parm.Npre_train = 1000;
bayes_parm.Ntrain     = 1000;
bayes_parm.skip       = 50;

%% --- Prior setting
bayes_parm.a0     = 1;
bayes_parm.a0_act = 100; 
% б a0_act=[] Ȥa0_act ưꤹˤ
% act ѥ󤬼¼ŪUniform ѥˤʤ롣Ĵ档

bayes_parm.prior_weight = 10e-5; % relative influence of prior information on data(from 0 to 1 real)

bayes_parm.v0     = 0.01; 
bayes_parm.Tv0    = 0; 

% --- Input file(relative path from proj_root)
bayes_parm.brainfile = [];
bayes_parm.areafile  = [];
bayes_parm.actfile   = [];
bayes_parm.megfile   = [];
bayes_parm.basisfile = [];

% --- Output file(relative path from proj_root)
bayes_parm.bayesfile = [];

% --- Specify time window by sample numbar
bayes_parm.twin_meg  = []; % Time window for analysis
bayes_parm.Tperiod   = []; % Time period for current estimation 
bayes_parm.Tnext     = []; % Time step for next period

% --- Current area and fMRI activity
bayes_parm.area_key  = 'Cortex';
bayes_parm.act_key   = {'Uniform'};

%% --- Spatial smoothing radius & max radius
bayes_parm.Rfilt  = [6e-3]; % [m]

%% --- Global window
bayes_parm.reduce_global = 1;
bayes_parm.Rfilt_global  = bayes_parm.Rfilt;
bayes_parm.area_key_global = 'Cortex';

%% --- Soft normal constraint
bayes_parm.soft_mode = 0;	% = 1: Soft normal constraint
% tangential variance coefficient
bayes_parm.tan_var = 1 ;
% tangential variance max
bayes_parm.var_max = 1/sqrt(2) ;
% ʬ = sin( tan_var * ʿˡγʿ) <= var_max

% --- Estimation model 
bayes_parm.forward_model    = 'focal';
bayes_parm.noise_estimation_model = 1;
bayes_parm.noise_model = 3;
bayes_parm.update_sx = ON;
bayes_parm.update_v  = OFF;
bayes_parm.flag_baseline  = 0;
bayes_parm.flag_noise_set = 0;
%bayes_parm.megnoisefile    = []; % relative path from proj_root
bayes_parm.megfile_baseline = []; % relative path from proj_root
bayes_parm.twin_noise      = [];
%bayes_parm.twin_global     = [];
bayes_parm.twin_baseline    = [];
bayes_parm.basisfile_global = [];% relative path from proj_root

%% --- Flag
bayes_parm.patch_norm      = OFF;
bayes_parm.cont_pr         = OFF; 
bayes_parm.temporal_filter = OFF;
bayes_parm.trial_average   = OFF; 
bayes_parm.expand_spatial_filter = ON;     
bayes_parm.spatial_smoother ='subj'; % spatial filter calculate from
                             % = 'std': Standard brain.
                             % = 'subj' Individual brain.
bayes_parm.remove_crossed_area   = ON;
bayes_parm.variance_orientation  = OFF;  

%% --- Optinal parameters 
bayes_parm.reduce = 1;
bayes_parm.cosval = cos(pi);
bayes_parm.Fdmin = 1e-50;
bayes_parm.a_min = 1e-6;
bayes_parm.a_max = 1e6;
bayes_parm.noise_reg = 0.1;

