function vb_plot_area(brain_file, area_file, area_keys, area_colors, Inflate, LR)
% plot cortical model and cortical area.
% [Usage]
%    vb_plot_area(brain_file, area_file, [area_keys], [area_colors], [Inflate], [LR]);
% [Input]
%     brain_file : VBMEG Cortical model file(.brain.mat)
%      area_file : VBMEG Cortical area file(.area.mat)
%      area_keys : (optional)plot area name list.                 {Narea x 1}
%                  if not specified or empty, all the area are plotted.
%    area_colors : (optional)color of area list([R G B] each from 0 to 1.)  [Narea x 3]
%                  if not specified or empty, defined color map in the area_file is used.
%                  if not defined in the area_file, colormap:hsv(Narea) is used.
%        Inflate : (optioal)
%                  1: Inflate model.  [default]
%                  0: Original model.
%             LR : (optional)
%                  'LR' : Left and Right brain is plotted. [default]
%                  'L'  : Left brain is plotted.
%                  'R'  : Right brain is plotted.
% [Output]
%    none
% [See also]
%    area_keys = vb_get_keyset_area(area_file);

%
% --- Previous check
%
if ~exist('area_file', 'var') || isempty(area_file)
    error('area_file not specified.');
end
if ~isempty(area_file) && exist(area_file, 'file') ~= 2
    error('Specified area file not found.');
end
if ~exist('area_keys', 'var')
    area_keys = [];
end
if ischar(area_keys)
    area_keys = {area_keys};
end

if ~exist('Inflate', 'var')
    Inflate = true;
end
if ~exist('LR', 'var')
    LR = 'LR';
end
    
if ~exist('area_colors', 'var') || isempty(area_colors)
    area_colors = [];
end

% Load and plot cortex
plot_parm = vb_set_plot_parm;
plot_parm.LRflag = LR;

if Inflate == true
    [V, F, tmp, inf_C] = vb_load_cortex(brain_file, 'Inflate');
    vb_plot_cortex(plot_parm, V, F, inf_C);
else
    [V,F] = vb_load_cortex(brain_file);
    vb_plot_cortex(plot_parm, V, F);
end
axis equal;
hold on;

% plot area
switch upper(plot_parm.LRflag)
 case 'L'
  F0 = F.F3L;
 case 'R'
  F0 = F.F3R;
 case 'LR'
  F0 = F.F3;
end

if area_file
    if isempty(area_keys)
        area_keys = vb_get_keyset_area(area_file);
    end
    
    for k=1:length(area_keys)
        area = vb_get_area(area_file, area_keys{k});
        if isempty(area_colors) && ~isfield(area, 'clr')
            area_colors = hsv(length(area_keys));
        else
            area_colors = [area_colors; area.clr];
        end
        FF   = vb_patch_select2(area.Iextract, F0, size(V,1));
        if isempty(FF), continue; end
        alpha = 0.7;
        patch('Faces',FF,'Vertices',V, 'FaceAlpha', alpha, ...
          'FaceColor',area_colors(k, :),'EdgeColor','none','FaceLighting','none');
    end
end
