function	vb_plot_slice( B, V, zindx, xymode, Nsubfig, Msize)
% Plot specified vertex points on MRI image
%
% -- Syntax
% vb_plot_slice( B, V, zindx, xymode, Nsubfig, Msize)
%
% -- Input
% B : 3D-image
% V : vertex coordinate
% --- Optinal Input (= Default)
% zindx   : slice z-index to plot  (= [140:10:190])
% Nsubfig : # of subplot   (= [3, 3])
% Msize   : Marker size
% xymode  :  2D plot mode for X-Y 
%        = 0   : plot without transpose
%        = 1   : plot by transposing 2D-image matrix
%
% 2006/10/20 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% zindx : slice z-coordinate
if ~exist('zindx','var'), zindx = [2:2:60]; end; 
if ~exist('xymode','var'), xymode = 1; end; 
if ~exist('Nsubfig','var'), Nsubfig = [ 3, 3 ]; end; 
if ~exist('Msize','var'), Msize=2; end; 

NX=Nsubfig(1); 
NY=Nsubfig(2); 

% z-width for vartex selection
dz = 1;

Nfig = length(zindx);
nfig = NX*NY;

for n=1:Nfig
	if nfig==NX*NY, 
		figure; nfig=1;
	else
		nfig=nfig+1;
	end;
	
	subplot(NY,NX,nfig);
	z = zindx(n);
	
	% slice plot
	h=image(B(:,:,zindx(n)),'CDataMapping','scaled');
	
	axis('equal'); 
	axis('tight');
	title(['z-slice (' num2str(zindx(n),3) ')'])
	colormap(gray);
	hold on
%	xlabel('X');
%	ylabel('Y');
	
	if ~exist('V','var') | isempty(V), continue; end;
	
	% vertex plot
	switch	xymode
	case	{0},
		% plot without transpose
		ix = find( V(:,3) >= (z-dz) & V(:,3) < (z+dz));
		Nv = length(ix);
		plot(V(ix,1),V(ix,2),'r.','MarkerSize',Msize);
	case	1,
		% plot by transposing 2D-image matrix
		ix = find( V(:,3) >= (z-dz) & V(:,3) < (z+dz));
		Nv = length(ix);
		plot(V(ix,2),V(ix,1),'r.','MarkerSize',Msize);
	end
end;

colormap(gray);
%colormap(jet);


