function	vb_plot_corpus( V,F,Iremove,Vindx )
%
% ---------- Plot removed corpus
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

fclr = [0.8 0.7 0.6];
eclr = 'none';

angl = [ 35  20; -35  20];
%angl = [ -90 -20; 90 -20];

NL	 = F.NdipoleL;
FL	 = F.F3L;
FR	 = F.F3R;
NV   = size(V,1);

Lmax = max(V(1:NL,:));
Lmin = min(V(1:NL,:));
Rmax = max(V((NL+1):end,:));
Rmin = min(V((NL+1):end,:));

FLremove = vb_patch_select(Iremove,FL,NV);
FLmodel  = vb_patch_select(Vindx,FL,NV);

FRremove = vb_patch_select(Iremove,FR,NV);
FRmodel  = vb_patch_select(Vindx,FR,NV);

light_mode = 1;
NX=2;
NY=1;

subplot(NY,NX,1);
vb_plot_surf(V,FLmodel,fclr,eclr,light_mode);
hold on;
vb_plot_surf(V,FLremove,'r');

view(angl(1,:));
title('Corpus region in left brain')

xlim([Lmin(1) Lmax(1)]);
ylim([Lmin(2) Lmax(2)]);
zlim([Lmin(3) Lmax(3)]);

subplot(NY,NX,2);
vb_plot_surf(V,FRmodel,fclr,eclr,light_mode);
hold on;
vb_plot_surf(V,FRremove,'r');

view(angl(2,:));
title('Corpus region in right brain')

xlim([Rmin(1) Rmax(1)]);
ylim([Rmin(2) Rmax(2)]);
zlim([Rmin(3) Rmax(3)]);
