function vb_plot_brain_mask(avw,analyzefile)
% Plot brain and cortex mask image on MRI slices
%  vb_plot_brain_mask(avw,analyzefile)
% --- Input
% analyzefile
% avw.img  : 3D brain mask image (SPM-right)
%
% Label value
%  1 = CSF
%  2 = Gray
%  3 = White
%  4 = Cerebellum
%  5 = Brainstem
%
% 2007/6/15 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% subplot  
Nfig  = [3, 3];
% 饤ɽ Z-ɸꥹ
zindx = fix([80:15:200]);

% Subject 3D image
[B, Vdim, Vsize] = vb_load_analyze_to_right(analyzefile);

zindx = fix(zindx/Vsize(3));

% 
% --- Plot brain on slices
%

% Brain index
ix_brain  = find( avw.img(:) > 0 );

% Transform brain 1D-index to 3D-voxel index
[ix,iy,iz] = ind2sub(Vdim,ix_brain);

vb_plot_slice( B, [ix,iy,iz], zindx, 1, Nfig);

% 
% --- Plot cortex on slices
%

% Cortex index
ix_cortex = find( avw.img(:)==2 | avw.img(:)==3);

% Transform cortex 1D-index to 3D-voxel index
[ix,iy,iz] = ind2sub(Vdim,ix_cortex);

vb_plot_slice( B, [ix,iy,iz], zindx, 1, Nfig);


return
