function A = vb_spherical_harmo_coef(Xhead, Qhead, N, Rmax, Xmeg, Qmeg)
% calculate spherical harmonic coefficient
% [usage]
%   A = vb_spherical_harmo_coef( Xhead, Qhead, N, Rmax, Xmeg, Qmeg)
% [input]
%   Xhead : head surface (NPx3)
%   Qhead : normal vector of head surface (NPx3)
%       N : order of function
%    Rmax : radius
%    Xmeg : sensor coordinates
%    Qmeg : sensor orientations
% [output]
%       A : calculated coefficient
% [note]
%
% [history]
%   2006.07.06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

B = vb_multi_sarvas(Xhead, Qhead, Xmeg, Qmeg);

YG = vb_spherical_grad(Xhead, Qhead, N, Rmax, 'f');

YY = sqrt(sum(YG .^2));
YY_no_zero = find(YY < eps);
YY(YY_no_zero) = eps;
dist = repmat(YY,size(YG,1),1);
YG_bar = YG ./ dist;

x1 = diag(1 ./ YY);
x2 = pinv(YG_bar' * YG_bar);
x3 = YG_bar' * B;
A = x1 * (x2 * x3);

return;
