function Headinfo = vb_headinfo_set_xxhead(headinfo, xxhead)
% setter Headinfo.XXhead
% [usage]
%   Headinfo = vb_headinfo_set_xxhead(headinfo, xxhead)
% [input]
%   headinfo : <optional> <<struct>> Headinfo
%            :  if it is not specified or is empty, Headinfo will be created
%     xxhead : <optional> value of XXhead (normal vector)
%            :  if it is not specified or is empty, [] will be set
% [output]
%   Headinfo : <<struct>> updated Headinfo
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('headinfo', 'var') headinfo = []; end;
if ~exist('xxhead', 'var')    xxhead = []; end;
[Headinfo, xxhead] = inner_check_arguments(headinfo, xxhead);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Headinfo.XXhead = xxhead;
if nargout ~= 1
  error('!!! You must receive updated Headinfo !!!');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [headinfo, xxhead] = inner_check_arguments(headinfo, xxhead)
% especially do nothing
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
