function Headinfo = vb_headinfo_set_fhead(headinfo, fhead)
% setter Headinfo.Fhead
% [usage]
%   Headinfo = vb_headinfo_set_fhead(headinfo, fhead)
% [input]
%   headinfo : <optional> <<struct>> Headinfo
%            :  if it is not specified or is empty, Headinfo will be created
%      fhead : <optional> value of Fhead (coordinate index set of patch)
%            :  if it is not specified or is empty, [] will be set
% [output]
%   Headinfo : <<struct>> updated Headinfo
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('headinfo', 'var') headinfo = []; end;
if ~exist('fhead', 'var')    fhead = []; end;
[Headinfo, fhead] = inner_check_arguments(headinfo, fhead);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Headinfo.Fhead = fhead;
if nargout ~= 1
  error('!!! You must receive updated Headinfo !!!');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [headinfo, fhead] = inner_check_arguments(headinfo, fhead)
% especially do nothing
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
