function Headinfo = vb_headinfo_make(Headinfo, ...
  Vhead, Fhead, XXhead, LayerTag, Sigma, Rmethod, R, Npatch, Nvertex)
% make or update Headinfo struct
% [usage]
%   Headinfo = vb_headinfo_make(Headinfo,
%     Vhead, Fhead, XXhead, LayerTag, Sigma, Rmethod, R, Npatch, Nvertex)
% [input]
%   Headinfo : <required> exist Headinfo. empty is O.K.
%            :  If it is empty, new Headinfo struct will be created.
%            :  If it is NOT empty, given Headinfo will be updated.
%      Vhead : <required> empty is O.K. 
%      Fhead : <required> empty is O.K.
%     XXhead : <required> empty is O.K.
%   LayerTag : <required> empty is O.K.
%      Sigma : <required> empty is O.K.
%    Rmethod : <required> empty is O.K.
%          R : <required> empty is O.K.
%     Npatch : <required> empty is O.K.
%    Nvertex : <required> empty is O.K.
% [output]
%   Headinfo : <<struct>>
%            : (e.g.)
%            :      Vhead: [3774x3 double]
%            :      Fhead: [7536x3 double]
%            :     XXhead: [3774x3 double]
%            :   LayerTag: [3x5 char]
%            :      Sigma: [0.62 0.03 0.62]
%            :    Rmethod: 'MEAN'
%            :          R: [0.0770 0.0828 0.0932]
%            :     Npatch: [3x2 double]
%            :    Nvertex: [3x2 double]
%
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('Vhead', 'var')    Vhead = []; end;
if ~exist('Fhead', 'var')    Fhead = []; end;
if ~exist('XXhead', 'var')   XXhead = []; end;
if ~exist('LayerTag', 'var') LayerTag = []; end;
if ~exist('Sigma', 'var')    Sigma = []; end;
if ~exist('Rmethod', 'var')  Rmethod = []; end;
if ~exist('R', 'var')        R = []; end;
if ~exist('Npatch', 'var')   Npatch = []; end;
if ~exist('Nvertex', 'var')  Nvertex = []; end;

[Headinfo, Vhead, Fhead, XXhead, ...
    LayerTag, Sigma, Rmethod, R, Npatch, Nvertex] = ...
  inner_check_arguments( Headinfo, ...
    Vhead, Fhead, XXhead, LayerTag, Sigma, Rmethod, R, Npatch, Nvertex);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isempty(Headinfo)
  % create or reset new Headinfo
  Headinfo = vb_headinfo_set_vhead(Headinfo,Vhead);
  Headinfo = vb_headinfo_set_fhead(Headinfo,Fhead);
  Headinfo = vb_headinfo_set_xxhead(Headinfo,XXhead);
  Headinfo = vb_headinfo_set_layertag(Headinfo,LayerTag);
  Headinfo = vb_headinfo_set_sigma(Headinfo,Sigma);
  Headinfo = vb_headinfo_set_rmethod(Headinfo,Rmethod);
  Headinfo = vb_headinfo_set_radius(Headinfo,R);
  Headinfo = vb_headinfo_set_npatch(Headinfo,Npatch);
  Headinfo = vb_headinfo_set_nvertex(Headinfo,Nvertex);
  
else

  % update data which is specified
  if ~isempty(Vhead)
    Headinfo = vb_headinfo_set_vhead(Headinfo,Vhead); end;
  if ~isempty(Fhead)
    Headinfo = vb_headinfo_set_fhead(Headinfo,Fhead); end;
  if ~isempty(XXhead)
    Headinfo = vb_headinfo_set_xxhead(Headinfo,XXhead); end;
  if ~isempty(LayerTag)
    Headinfo = vb_headinfo_set_layertag(Headinfo,LayerTag); end;
  if ~isempty(Sigma)
    Headinfo = vb_headinfo_set_sigma(Headinfo,Sigma); end;
  if ~isempty(Rmethod)
    Headinfo = vb_headinfo_set_rmethod(Headinfo,Rmethod); end;
  if ~isempty(R)
    Headinfo = vb_headinfo_set_radius(Headinfo,R); end;
  if ~isempty(Npatch)
    Headinfo = vb_headinfo_set_npatch(Headinfo,Npatch); end;
  if ~isempty(Nvertex)
    Headinfo = vb_headinfo_set_nvertex(Headinfo,Nvertex); end;
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [Headinfo, Vhead, Fhead, XXhead, ...
  LayerTag, Sigma, Rmethod, R, Npatch, Nvertex] = ...
  inner_check_arguments( Headinfo, ...
    Vhead, Fhead, XXhead, LayerTag, Sigma, Rmethod, R, Npatch, Nvertex)

% especially do nothing for now
% if you want to set default value, you can do it here.
% (e.g.)
%  if isempty(Vhead) Vhead = [0 0 0]; end;

return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
