function radius = vb_headinfo_get_radius(Headinfo)
% getter of Headinfo.R
% [usage]
%   radius = vb_headinfo_get_radius(Headinfo)
% [input]
%   Headinfo : <required> <<struct>>
%            :  if this does not have target field, return empty ([]).
% [output]
%     radius : Headinfo.R
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('Headinfo', 'var') Headinfo = []; end;
[Headinfo] = inner_check_arguments(Headinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
radius = Headinfo.R;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [Headinfo] = inner_check_arguments(Headinfo)
if isempty(Headinfo)
  error('Headinfo is a required parameter');
end

if ~isfield(Headinfo, 'R') Headinfo.R = []; end;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
