function vb_analyze2curry(analyzefile,outfile_pref,flag,flip_flag)
% Convert analyzefile to Curry image file
% vb_analyze2curry(analyzefile,outfile_pref)
% vb_analyze2curry(analyzefile,outfile_pref,flag,flip_flag)
%
% AnalyzeǡCurryѤѴ
% ϡAnalyze饤
%   analyzefile
% ϡCurryѥե
%   out_pref: ϥե̾
% إåե [outfile_pref].imd ȡ
% ǡ     [outfile_pref].img 롣
% --- Optional input
% flag: 
% 'header'ꤹȡimdեΤߺ롣
%
% flip_flag
%  if flip_flag == 1, X-dir is flipped
%
% ɸ
% 饤θSagital
% [Curry] 
% X:Right(1)->Left(256)
% Y:Front(1)->Back(256)
% Z:Bottom(1)->Top(256)
%
% [Analyze Left-hand coordinate]
% X: Right(1)  -> Left(191) 
% Y: Back(1)   -> Front(256)
% Z: Bottom(1) -> Top(256) 
%    B(x,:,:) : Sagital slice
%
%
% 2004-01-31 Taku Yoshioka
% 2007-06-20 M.Sato
% 2009-12-21 rhayashi supported NIfTI format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('flip_flag','var'), flip_flag = 0; end;

% load data and reorient to LAS
[B, Vdim, Vsize] = vb_load_analyze_to_left(analyzefile);

v_max = max([B(:)]);
%
% إåե
%
fprintf('--- Create header file\n');

%	SLICE_DISTANCE	= 1.000000
%	SLICE_NR	= 179
%	SLICE_VALID	= 179
%	SLICE_NR1ST	= 1
%	RAW_IMAGE_FORMAT	= 2
%	RAW_NUMBER_OF_BITS	= 16
%	RAW_MOST_SIGN_BIT	= 15
%	RAW_OFFSET	= 0
%	RAW_PIXEL_SIZE_X	= 1
%	RAW_PIXEL_SIZE_Y	= 1
%	RAW_SIZE_X	= 256
%	RAW_SIZE_Y	= 256
%	SLICE_ORDER	= 1

fp = fopen([outfile_pref '.imd'],'w');
fprintf(fp,'IMAGE_KEYWORDS START\n');
fprintf(fp,'\tSLICE_DISTANCE\t= %f\n',Vsize(1));
fprintf(fp,'\tSLICE_NR\t= %d\n',Vdim(1));
fprintf(fp,'\tSLICE_VALID\t= %d\n',Vdim(1));
fprintf(fp,'\tSLICE_NR1ST\t= 1\n');
fprintf(fp,'\tRAW_IMAGE_FORMAT\t= 2\n');
fprintf(fp,'\tRAW_NUMBER_OF_BITS\t= 16\n');
fprintf(fp,'\tRAW_MOST_SIGN_BIT\t= 15\n');
fprintf(fp,'\tRAW_OFFSET\t= 0\n');
fprintf(fp,'\tRAW_PIXEL_SIZE_X\t= %d\n',Vsize(2));
fprintf(fp,'\tRAW_PIXEL_SIZE_Y\t= %d\n',Vsize(3));
fprintf(fp,'\tRAW_SIZE_X\t= %d\n',Vdim(2));
fprintf(fp,'\tRAW_SIZE_Y\t= %d\n',Vdim(3));
fprintf(fp,'\tSLICE_ORDER\t= 1\n');
fprintf(fp,'IMAGE_KEYWORDS END');
fclose(fp);

%
% DICOM᡼ɤ߹ߡޤȤƥե¸
%
if nargin >= 3 & strcmp(flag,'header')
  return;
else
  fprintf(['--- Save image data (' outfile_pref '.img)\n']);

  Z = 65535/v_max;
  fp = fopen([outfile_pref '.img'],'w');
  
  img = zeros(Vdim(2),Vdim(3));
  
%  Ƚۤʤν
%  for n=Vdim(1):-1:1   % X flip
%    img = flipud(img); % Y flip
%    img = fliplr(img); % Z flip
%    img = img';        % Y<->Z

  % ǡν񤭹
  if flip_flag == 0,
  	xlist = 1:Vdim(1);	% X : no flip
  else
  	xlist = Vdim(1):-1:1; % X flip
  end
  
  for n=xlist
    img = squeeze(B(n,:,:));
    img = flipud(img); % Y flip
    img = fliplr(img); % Z flip
  	fwrite(fp, img(:).*Z ,'uint16');
  end
  

  fclose(fp);
end

