function D = vb_solid_auto_grk(D,F,Sout)
% Auto-solid angle calculation by Gararkin method
%  D = vb_solid_auto_grk(D,F,Sout)
% ĺη׻
% ʽŤ߷ؿ򻰳̾ʬͿä
% (1ݥƥ󥷥)
%
% D     : ĺ (ŤդΩγ)
% Sout  : ̤ˡ
% F     : ĺǥå
%
% 2004-02-06 Taku Yoshioka
% 2004-12-26 M. Sato modified
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% ʽŤ߷ؿ򻰳̾ʬͿ
%               гʬޤ
% A     : ĺ (ʽŤ߷)

% ̤οNumber of triangle patch
NF = size(F,1);
NV = size(D,1);

S  = sqrt(sum(Sout.^2,2));

for i = 1:NF
	ix1 = F(i,1);
	ix2 = F(i,2);
	ix3 = F(i,3);
	S1  = S(i)/12;
	S2  = S(i)/24;
	
%	A(ix1,ix1) = A(ix1,ix1) + S1;
%	A(ix2,ix2) = A(ix2,ix2) + S1;
%	A(ix3,ix3) = A(ix3,ix3) + S1;
%	
%	A(ix1,ix2) = A(ix1,ix2) + S2;
%	A(ix2,ix1) = A(ix2,ix1) + S2;
%	A(ix1,ix3) = A(ix1,ix3) + S2;
%	A(ix3,ix1) = A(ix3,ix1) + S2;
%	A(ix2,ix3) = A(ix2,ix3) + S2;
%	A(ix3,ix2) = A(ix3,ix2) + S2;
	
	D(ix1,ix1) = D(ix1,ix1) + S1;
	D(ix2,ix2) = D(ix2,ix2) + S1;
	D(ix3,ix3) = D(ix3,ix3) + S1;
	
	D(ix1,ix2) = D(ix1,ix2) + S2;
	D(ix2,ix1) = D(ix2,ix1) + S2;
	D(ix1,ix3) = D(ix1,ix3) + S2;
	D(ix3,ix1) = D(ix3,ix1) + S2;
	D(ix2,ix3) = D(ix2,ix3) + S2;
	D(ix3,ix2) = D(ix3,ix2) + S2;
end

% This code save the memory 
for i=1:(NV*NV)
	D(i) = D(i) + (1/NV);
end

% Following code may alocate new memory space for calculation
% and this cause memory error for large number of triangles
% D =  D + (1/NV);

