function [D, s0] = vb_solid_angle_grk(V,F,xx)
% solid angle calculation by Gararkin method
%   [D, s0] = vb_solid_angle_grk(V,F,xx)
% ĺη׻
% (1ݥƥ󥷥)
%
% D     : ĺ (ŤդΩγ)
% s0     : ̤ˡ
%
% V     : ̤κɸ
% F     : ĺǥå
% xx    : ̤ˡ٥ȥ
%
%
% 2004-02-06 Taku Yoshioka
% 2004-12-26 M. Sato modified
% 2007-12-26 M. Sato modified
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Nskip = 100;
NSKIP = 1000;

%fprintf('--- Solid angle calculation\n');
% ̤οNumber of triangle patch
NF = size(F,1);
NV = size(V,1);

% ̷
D = zeros(NV,NV);
%A = zeros(NV,NV);

% ̤ĺtriangle vertex
x1 = V(F(:,1),:);
x2 = V(F(:,2),:);
x3 = V(F(:,3),:);

% ̤ˡ׻()
z1 = x2-x1;
z2 = x3-x1;
s0 = vb_cross2(z1,z2);
S  = sum(s0.^2,2);
Sinv2 = 1./S;
S = sqrt(S);

% ˡ򳰸ˤ
xxS = (xx(F(:,1),:)+xx(F(:,2),:)+xx(F(:,3),:))./3;
ix  = find( sum(s0.*xxS,2) < 0 );
% ĺؤ
tmp      = x2(ix,:);
x2(ix,:) = x3(ix,:);
x3(ix,:) = tmp;
% ǥåؤ
tmp      = F(ix,2);
F(ix,2)  = F(ix,3);
F(ix,3)  = tmp;

s0(ix,:) = -1*s0(ix,:);

%
% ̤3ĤˤĤơ鸫¾̤
% (Ťդ)ΩγѤ׻̤ĺǥǥåͿ
% 3ĤδؿؤδͿ׻롣
% 

% (໰)˴ؤ롼
for n = 1:NF
  % 
  ip = [(4*x1(n,:) +   x2(n,:) +   x3(n,:))/6; ...
	    (  x1(n,:) + 4*x2(n,:) +   x3(n,:))/6; ...
	    (  x1(n,:) +   x2(n,:) + 4*x3(n,:))/6];
  
  % ʬȤΥǥå
  ix = [1:(n-1), (n+1):NF];
  
  Fn = F(ix,:);	% оݻ̤ĺǥå
  s  = s0(ix,:);% ˡ
  y1 = x1(ix,:);% оݻ̤3Ĥĺ
  y2 = x2(ix,:);% оݻ̤3Ĥĺ
  y3 = x3(ix,:);% оݻ̤3Ĥĺ

  Sinv = Sinv2(ix);% 1/̤
  
  % ŤդΩγѤη׻
  D0 = zeros(3,NV);

  % Ĥ˴ؤ롼
  for i = 1:3
    % x0 : (໰̤ΰĤ)
    x0 = ip(i,:);
	y0 = x0(ones(NF-1,1),:);
	
	% Ĥ鸫¾λ(оݻ)νŤդΩγ
	[omega1,omega2,omega3] = ...
	        vb_solid_other(y0,y1,y2,y3,s,Sinv);
	
	% оݻ̤ΣĤĺΩγѴͿʬ
    for j = 1:NF-1
      D0(i,Fn(j,1)) = D0(i,Fn(j,1))+omega1(j);
      D0(i,Fn(j,2)) = D0(i,Fn(j,2))+omega2(j);
      D0(i,Fn(j,3)) = D0(i,Fn(j,3))+omega3(j);
    end
  end
  
  % ŤդΩγѤοʬ(3Ĥ˴ؤŤդ)
  % SѤ2ܤʤΤǡ3*6*2=36ǳäƤ
  D(F(n,1),:) = D(F(n,1),:)+S(n)/36*(4*D0(1,:)+D0(2,:)+D0(3,:));
  D(F(n,2),:) = D(F(n,2),:)+S(n)/36*(D0(1,:)+4*D0(2,:)+D0(3,:));
  D(F(n,3),:) = D(F(n,3),:)+S(n)/36*(D0(1,:)+D0(2,:)+4*D0(3,:));
  
  if mod(n,Nskip)==0, fprintf('-'); end;
  if mod(n,NSKIP)==0, fprintf(' %3.0f %% done\n', 100*n/NF); end;
end

% ΩγѤ(Ωγ/2)=Фǳ
D   = (-1/(2*pi))*D;

return
