function B = vb_bem_meg_linear_grk(Bvol,Vs,Fs,V,J,X,Q)
% magnetic field by using BEM method
%  B = vb_bem_meg_linear_grk(Bvol,Vs,Fs,V,J,X,Q)
%
% Bvol : ĺ
% Vs : ̤κɸ
% Fs : ĺǥå
% V  : ήж˻Һɸ        (m)    (Ndipole,3)
% J  : ήж˻ҥ⡼  (A)    (Ndipole,3)
% X  : 󥵡ɸ             (Npick,  3)
% Q  : δ¬               (Npick,  3)
%
% B  : X ˤ뼧 ʥƥ    (Npick, Ndipole)
%
% ƩΨ = 4С10^(-7) (N/A^2), 1Tʥƥ= 1N/Am
%
% 2004-02-06 Taku Yoshioka
% 2004-12-26 M. Sato modified
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%  ѿμ
NS = size(X,1);		% 󥵡
NJ = size(V,1);		% ήж˻
NF = size(Fs,1);	% 
NV = size(Vs,1);    % ĺ

%  ȥݥƥ󥷥
B  = zeros(NS,NJ);	% ¬ X ˤ뼧
B0 = zeros(NS,1);
P0 = zeros(NV,1);

% ̤ĺtriangle vertex
x1 = Vs(Fs(:,1),:);
x2 = Vs(Fs(:,2),:);
x3 = Vs(Fs(:,3),:);

%% ̤
s0 = vb_cross2(x2-x1,x3-x1);
S  = sqrt(sum(s0.^2,2));

%%%% ¬Ǥμ׻ %%%

% ̤
ip1 = (4*x1+x2+x3)/6; 
ip2 = (x1+4*x2+x3)/6; 
ip3 = (x1+x2+4*x3)/6;

for n=1:NJ,
  % n-ܤж˻
  x0 = V(n,:);
  J0 = J(n,:);
  
  % ж˻ҥݥƥ󥷥 
  p1 = vb_dipole_pot(J0,x0,ip1);
  p2 = vb_dipole_pot(J0,x0,ip2);
  p3 = vb_dipole_pot(J0,x0,ip3);
  
  P0 = zeros(NV,1);
  
  % ̾Υݥƥ󥷥ʬνŤդ¤Ƕ
  for i = 1:NF
    ix1 = Fs(i,1);
    ix2 = Fs(i,2);
    ix3 = Fs(i,3);
    P0(ix1) = P0(ix1)+S(i)/36*(4*p1(i)+p2(i)+p3(i));
    P0(ix2) = P0(ix2)+S(i)/36*(p1(i)+4*p2(i)+p3(i));
    P0(ix3) = P0(ix3)+S(i)/36*(p1(i)+p2(i)+4*p3(i));
  end

  % ¬(󥵰)ˤж˻Ҽ׻
  B0 = vb_dipole_mag(J0,x0,X,Q);
	
  % ˶̥ݥƥ󥷥뤫ήͿ Bvol*P0 ä
  B(:,n) = B0 + Bvol*P0/(4*pi);		% (Nsensor x 1)
end;

B = B*(10^(-7));	% (ƩΨ)/(4) 
