function  [fileinfo,flg,fig_handler] = vb_job_bad_trial(datafile,job_mode, ...
	thred_val,prob_val,thred_ch,savefile,stat_file,std_mode)
% Find bad channel/trials by checking max value in each channel/trial
% --- Usage
% vb_job_bad_trial(datafile,job_mode, ...
%	thred_val,prob_val,thred_ch,actfile,stat_file,std_mode)
% --- Input
% datafile: cell string for multiple MEG/EEG epoch data files
% job_mode: 
% 	 1: channel/trial rejection in batch mode
%    2: 2D-Plot bad trial & channel for set of thresholds
%    3-6: Interactive mode
%    7,8: Stat mode to view distribution of trials with set of
% 	 10: just save trial statics without channel/trial rejection
%
% [savefile   '.info.mat']
%  : file name to save bad channel/trial info
%    or save trial statics without channel/trial rejection (mode 7,8,10)
% [stat_file '.info.mat']
%  : file name having trial statics made at the previous job
% 
% ---- Threshold value for bad channel selection
% - thred_val = [9 8]; 
%   threshold value for max(y) & diff(y) in one trial
%   if (ymax/ystd) > thred_val(1) | difmax/difstd > thred_val(2), 
%      it is marked as bad
%   For stat mode only, you can select multi values as list like
%   thred_val = [8:11; 7:10];
%               [vals_for_max(y); vals_for_diff(y)];
%
% - prob_val  = 0.023;
%   threshold probability to select bad channel
%   if more than (prob_val*Ntrial) trials are bad, the channel is rejected
%   For stat mode only, you can select multi values as list like
%   prob_val  = [0.05   0.01   0.001];
%
% - thred_ch  = 1/4;
%   if more than (Nch*thred_ch) channels are bad, the trial is rejected,
%   before checking bad channel.
%
% - std_mode  = 1;
%   = 0: std is averaged over all trials
%   = 1: std is averaged within one session (one BDF file)
% 
% 2022-4-27 k_suzuki
% 2009-2-1 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('std_mode','var') , std_mode = 1; end;

if ~isempty(datafile) && ~iscell(datafile),
	tmp = datafile;
	datafile = {tmp};
end;

if exist('stat_file','var') && exist([stat_file '.info.mat'],'file')
	% Load statics info (ratio. ymax)
	load([stat_file '.info.mat'],'fileinfo')
else
	% Get file info for multiple session MEG/EEG files
	% All trials are loaded
    if  length(datafile)==1&&strcmp(datafile{1}(end-8:end), '.info.mat')
        % If datafile is info.mat, then unpack all session files
        info = load(datafile{1});
        datafile = info.fileinfo.filename;
    end
    fileinfo = vb_get_multi_fileinfo(datafile);
end

% for compatibility
if isfield(fileinfo, 'channel_id')
    data_format = 'old';
elseif isfield(fileinfo, 'ActiveChannel')
    data_format = 'new';
end
if strcmp(data_format, 'new')
    fileinfo = vb_fileinfo_active_field_convert_to('old', fileinfo, datafile{1});
end

% ystd: amplitude mean calculated by histrgam for all trials in one channel
% ymax : Nch x Ntrial
% ystd : Nch x 1

if isfield(fileinfo,'ymax1')
    ymax1 = fileinfo.ymax1;
    ymax2 = fileinfo.ymax2;
    ystd1 = fileinfo.ystd1;
    ystd2 = fileinfo.ystd2;
    if ~isempty(datafile) 
		fileinfo = vb_get_multi_fileinfo(datafile);
	end
else
    ymax1 = [];
    ymax2 = [];
    ystd1 = [];
    ystd2 = [];
	fprintf('Load data ')
	for n=1:length(datafile)
		% Load MEG/EEG data
		fprintf('-')
		data = vb_load_meg_data(datafile{n});
		[max1,max2,std1,std2] = vb_channel_statics(data);
	    ymax1 = [ymax1 , max1];
	    ymax2 = [ymax2 , max2];
	    ystd1 = [ystd1 , std1];
	    ystd2 = [ystd2 , std2];
	end
	fprintf('\n')
end

% Compile data among multi-files for interactive mode
if job_mode==3||job_mode==4||job_mode==5||job_mode==6
	Nchannel = fileinfo.Nchannel;  % # of total channels
	Nsample  = fileinfo.Nsample ;  % # of samples
	Ntrial   = fileinfo.Ntrial  ;  % # of trials for each session
	Ntotal   = fileinfo.Ntotal  ;  % # of all trials 
	% Subsampling step (sampled data are used for visualization)
	tstep = 1;
	t = 1:tstep:Nsample;
	data_plt = zeros(Nchannel,length(t),Ntotal);
	jtry = 1;
	fprintf('Load data ')
	for n=1:length(datafile)
		% Load EEG data
		fprintf('-')
		data_tmp = vb_load_meg_data(datafile{n});
	    data_plt(:,:,jtry:jtry+Ntrial(n)-1) = data_tmp(:,t,:);
	    jtry = jtry+Ntrial(n);
	end
	[Nch,T,Ntry] = size(data_plt);
	fprintf('[Nch,T,Ntry] = [%d, %d, %d] \n',Nch,T,Ntry)
end

if std_mode == 0 
	ystd1 = mean(ystd1,2);
	ystd2 = mean(ystd2,2);
end

ratio1 = ymax1;
ratio2 = ymax2;

ix1  = find(ystd1 > 0);
ix2  = find(ystd2 > 0);

if size(ystd1,2) == 1
	ratio1(ix1,:) = vb_repmultiply(ymax1(ix1,:), 1./ystd1(ix1));
	ratio2(ix2,:) = vb_repmultiply(ymax2(ix2,:), 1./ystd2(ix2));
else
	ratio1(ix1) = ymax1(ix1)./ystd1(ix1);
	ratio2(ix2) = ymax2(ix2)./ystd2(ix2);
end

[Nch,Ntry] = size(ymax1);
thred_num  = Nch * thred_ch;

switch job_mode
case	1
	% Remove error trials first (batch mode)

	% 1. Find noisy trials with multiple bad channels
	ch_act  = [1:Nch];
	[try_err ,flg]= vb_find_bad_trial(ratio1,ratio2,ch_act,thred_val,thred_num);
	try_act = vb_setdiff2([1:Ntry],try_err);

	% 2. Find Bad Channel after removing noisy trials
	[ch_bad,flg] = vb_find_bad_channel(ratio1(:,try_act),ratio2(:,try_act), ...
									thred_val,prob_val);
	ch_act = vb_setdiff2([1:Nch],ch_bad);
	
	% 3. Find bad trials after removing bad channel
	try_bad  = vb_find_bad_trial(ratio1,ratio2,ch_act,thred_val);
	try_act = vb_setdiff2([1:Ntry],try_bad);
case	2
	%  2D-Plot bad trial & channel for set of thresholds
	vb_plot_max_ratio_image(ratio1,thred_val(1))
	vb_plot_max_ratio_image(ratio2,thred_val(2))
	
	ch_act  = 1:Nch;
	try_act = 1:Ntry;
    
%---- 3-6 are interactive mode
case	3
	% Check Bad channel interactively
	
	% 1. Find noisy trials with multiple bad channels
	ch_act  = [1:Nch];
	[try_err ,flg]= vb_find_bad_trial(ratio1,ratio2,ch_act,thred_val,thred_num);
	try_act = vb_setdiff2([1:Ntry],try_err);

	% 2, Find Bad Channel with large max_ratio
	ch_bad = vb_find_bad_channel(ratio1(:,try_act),ratio2(:,try_act),...
				thred_val,prob_val);
	
	% Check Bad channel interactively
	ch_bad = vb_plot_bad_channel(data_plt,ch_bad,flg);
	
	% Find bad trials with large max_ratio after removing bad channel
	ch_act  = vb_setdiff2([1:Nch],ch_bad);
	try_bad = vb_find_bad_trial(ratio1,ratio2,ch_act,thred_val);
	try_bad = vb_plot_bad_trial(data_plt(ch_act,:,:),try_bad,flg(ch_act,:));
	try_act = vb_setdiff2([1:Ntry],try_bad);
case	4
	% Check Bad trials interactively
	% 1. Find noisy trials with multiple bad channels
	ch_act  = [1:Nch];
	[try_err ,flg]= vb_find_bad_trial(ratio1,ratio2,ch_act,thred_val,thred_num);
	
	% Check Bad trials interactively
	try_bad = vb_plot_bad_trial(data_plt(ch_act,:,:),try_err,flg(ch_act,:));
	try_act = vb_setdiff2([1:Ntry],try_bad);
	
	% Find Bad Channel with large max_ratio
	ch_bad = vb_find_bad_channel(ratio1(:,try_act),ratio2(:,try_act),...
				thred_val,prob_val);
	
	ch_act = vb_setdiff2([1:Nch],ch_bad);
case	5
	% Check Bad trials interactively
	% 1. Find noisy trials with multiple bad channels
	ch_act  = [1:Nch];
	[try_err ,flg]= vb_find_bad_trial(ratio1,ratio2,ch_act,thred_val,thred_num);
	try_act = vb_setdiff2([1:Ntry],try_err);
	
	% Find Bad Channel with large max_ratio
	ch_bad = vb_find_bad_channel(ratio1(:,try_act),ratio2(:,try_act),...
				thred_val,prob_val);
	ch_act = vb_setdiff2([1:Nch],ch_bad);
	
	% Check Bad trials interactively
	try_bad = vb_find_bad_trial(ratio1,ratio2,ch_act,thred_val);
	try_bad = vb_plot_bad_trial(data_plt(ch_act,:,:),try_bad,flg(ch_act,:));
	try_act = vb_setdiff2([1:Ntry],try_bad);
case	6
	% Check trials interactively
	% Find Bad Channel with large max_ratio
	[ch_bad,flg] = vb_find_bad_channel(ratio1,ratio2,thred_val,prob_val);
	
	% Find bad trials with large max_ratio after removing bad channel
	ch_act  = vb_setdiff2([1:Nch],ch_bad);
	try_bad = vb_find_bad_trial(ratio1,ratio2,ch_act,thred_val);

	% Check Bad trials interactively
	try_bad = vb_plot_bad_trial(data_plt(ch_act,:,:),try_bad,flg(ch_act,:));
	try_act = vb_setdiff2([1:Ntry],try_bad);
	try_err = [];
    
%---- 7 and 8 are stat mode
case	7
	% Plot ymax histgram
    fig_handler(1)=figure;
	subplot 121
	[ylist1,h1,y1] = inner_plot_stat_hist(ratio1 ,[]);
	hold on
	title('Max/std of amplitude')
	subplot 122
	[ylist2,h2,y2] = inner_plot_stat_hist(ratio2 ,[]);
	hold on
	title('Max/std of derivative')
	% set output variable (No change)
	%flg  = [ylist1; ylist2];
	%data = [h1(:), y1(:), h2(:), y2(:)];
	ch_act  = 1:Nch;
	try_act = 1:Ntry;
	try_err = [];
	flg = [];
case	8
    if size(thred_val,1)==2
        thred_val_lst1 = thred_val(1,:);
        thred_val_lst2 = thred_val(2,:);
    else
        thred_val_lst1 = thred_val(1);
        thred_val_lst2 = thred_val(2);
    end
	% Plot ymax histgram
    fig_handler(1)=figure;
	subplot 121
	[ylist1,h1,y1] = inner_plot_stat_hist(ratio1 ,[]);
	hold on
	title('Max/std of amplitude')
	subplot 122
	[ylist2,h2,y2] = inner_plot_stat_hist(ratio2 ,[]);
	hold on
	title('Max/std of derivative')
	% set output variable (No change)
	%flg  = [ylist1; ylist2];
	%data = [h1(:), y1(:), h2(:), y2(:)];
    ch_act  = 1:Nch;
	try_act = 1:Ntry;
	try_err = [];
	flg = [];
	%  Plot bad trial & channel for set of thresholds
	vb_plot_max_ratio_image(ratio1,thred_val_lst1)
    fig_handler(2)=gcf;
	vb_plot_max_ratio_image(ratio2,thred_val_lst2)
    fig_handler(3)=gcf;
	vb_plot_channel_trial(ratio1,ratio2, ...
			thred_val_lst1,thred_val_lst2,prob_val,thred_num)
    fig_handler(4)=gcf;
%----- Just save trial statics
case	10
	ch_act  = 1:Nch;
	try_act = 1:Ntry;
	try_err = [];
	flg = [];
end

Ntry = length(try_act);
Nact = length(ch_act);

if job_mode==1 || job_mode==2 || job_mode==3 || job_mode==4 || job_mode==5 || job_mode==6
	fprintf('Active %d channel & %d epoch\n',Nact, Ntry)
	fprintf('Err trial= %d\n',length(try_err));
end

% channel & trial statistics
fileinfo.ymax1 = ymax1;
fileinfo.ymax2 = ymax2;
fileinfo.ystd1 = ystd1;
fileinfo.ystd2 = ystd2;

fileinfo.channel_id = ch_act;
fileinfo.act_trial  = try_act;
fileinfo = vb_fileinfo_active_field_convert_to(data_format, fileinfo, datafile{1});

if ~exist('savefile','var')||isempty(savefile), return;end

vb_save_active_info(fileinfo, [savefile '.info.mat']);

return
end
%% ---- END ---- %%

% Inner function for stat mode
function [ylist,h,yy] = inner_plot_stat_hist(y,plist)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[Nch, Ntry] = size(y);
Nbin = 500;
ymax = max(y(:));

[h, yy] =hist(y(:),Nbin);

[ylist, p] = vb_find_hist_threshold(h,yy,plist);

% sum( pd * dy) = 1
dy = yy(2) - yy(1);
pd = p / dy;

hold on
type  = {'r--', 'b--', 'm--', 'c--'}; % Max num of plist=4

N = length(ylist);
lgn = cell(N-1,1);
% Plot thresholds
for n=1:N
	plot([ylist(n) ylist(n)],[0 max(pd)], type{n})
    lgn{n} = ['p=' num2str(plist(n))];
end
% legend(lgn)
xlim([0 ymax])

% plot histgram
plot(yy,pd);
end
