function vb_job_smooth_head(headfile_old, headfile_new, Para)
% Smooth surface by morphology & spring model, and reduce number of vertex
%   vb_job_smooth_head( headfile_old, headfile_new, Para )
%
% --- Input parameters
% headfile_old: Original head model file (Usually imported Curry surface)
% headfile_new: New head model file. 
% Para : Surface smoothing parameter set
% Para.analyze_file : analyze file for plot
% Para.brain_file   : brain file
% --- Optional field ( = Default )
% Para.Nvertex : Final surface vertex number ( = 5000)
% Para.Nloop   : Iteration number of expand to boundary ( = 200)
% Para.Nlast   : Iteration number of surface smoothing  ( = 20)
% Para.tangent_rate : Rate of smoothing force ( = 0.3)
% Para.Radius  : morphological radius ( = [ 4 -4 ])
% Para.vstep   : Subsampling step for mask image [mm]
% --- Optional input for result plot
% Para.plot_mode   = 0 : No plot
%                  = 1 : plot     (Default)
%
% 2005-05-12 Taku Yoshioka
% modefied M. Sato 2006-10-19
% M. Sato 2007-3-16
% ---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% Default parameter
%
if nargin<3, Para = []; end

if ~isfield(Para,'analyze_file')| isempty(Para.analyze_file), 
	error('No analyze file is specified');
end

if ~isfield(Para,'Nloop'), Para.Nloop = 200; end
if ~isfield(Para,'Nlast'), Para.Nlast = 20; end
if ~isfield(Para,'Nvertex'), Para.Nvertex = 5000; end
if ~isfield(Para,'tangent_rate'), Para.tangent_rate = 0.3; end
if ~isfield(Para,'vangle'), Para.vangle = [40 25 ; -130 10]; end
if ~isfield(Para,'Radius'), Para.Radius = [ 4 -4 ]; end;
if ~isfield(Para,'brain_file'), Para.brain_file = []; end;
if ~isfield(Para,'plot_mode'), Para.plot_mode = 1; end;
if ~isfield(Para,'vstep'), Para.vstep = 2; end;

%
% Load original head model
%
load(headfile_old,'Vhead','Fhead','XXhead');

%
%----- ɸѴ: Spm_right [m] -> Analyze_right [mm]
%
disp(['--- Change coordinate to Analyze_right [mm] ']);

[Vdim, Vsize] = analyze_hdr_read(Para.analyze_file);
Vhead = vb_spm_right_to_analyze_right_mm(Vhead, Vdim, Vsize);
Para.Dim  = vb_mask_image_size(Vdim,Vsize,Para.vstep);

maxV  = max(Vhead);
minV  = min(Vhead);

%
% Surface smoothing
%
disp('--- Surface smoothing');

[Vhead,Fhead,XXhead] = vb_surf_smooth_expand(Vhead,Fhead,XXhead, Para);

maxV  = max(Vhead) - maxV;
minV  = min(Vhead) - minV;

fprintf('Max_new - Max_old = [%f, %f, %f]\n', maxV)
fprintf('Min_new - Min_old = [%f, %f, %f]\n', minV)

% 
% --- Back to original coordinate
%  Vox  = V*1000 - Vorgin;
%   V   = (Vox + Vorgin) * 0.001;
disp(['--- Back to Spm_right [m] coordinate ']);

Vhead = vb_analyze_right_mm_to_spm_right(Vhead,Vdim,Vsize);

%
% Save result
%
disp(['--- Save head model file: ']);
disp([headfile_new]);
vb_fsave(headfile_new,'Vhead','Fhead','XXhead');

clear Vhead Fhead XXhead

%
% Check cortex is inside of skull
%

if Para.plot_mode == 0, return; end;

vb_plot_head_surf(headfile_new, Para.brain_file)

view(Para.vangle(2,:))
alpha(0.9);

if ~isempty(Para.analyze_file)
	vb_plot_slice_head(headfile_new, Para.analyze_file, Para.brain_file);
end
