function job_view_lf_push_rotate_button(inst_id)
% Change rotation mode
% 
% --- Syntax
% function job_view_lf_push_rotate_button(inst_id)
%
% --- History
% 2008-01-27 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.viewlf{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.viewlf{inst_id}.h_fig;
h_cortex = vbmeg_inst.viewlf{inst_id}.h_cortex;
h_rotate = vbmeg_inst.viewlf{inst_id}.pb5;

%
% Change rotation mode and set callback function
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rot_flag = get(h_rotate, 'Value');
if rot_flag, 
  on_off = 'on';
else
  on_off = 'off';
end
[a,b] = vb_matlab_version;
if (a+b*0.1)>=7.3, % MATLAB 7.3 or later
  h = rotate3d;
  set(h, 'Enable', on_off);
  set(h,'ActionPostCallback',@after_rotate_callback);
else
  rotate3d(h_space, on_off);
end

%
% Callback function after rotating the plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function after_rotate_callback(obj,event_obj)

child1 = get(obj,'Children');

for i=1:length(child1)
  if strcmp(get(child1(i),'Type'),'axes'), 
    child2 = get(child1(i),'Children');
    for j=1:length(child2)
      if strcmp(get(child2(j),'Type'),'light'),
        camlight(child2(j),'headlight');
        return;
      end
    end
  end
end

