function job_view_lf_load_leadfield(inst_id,basisfile)
% Load leadfield
%
% --- Syntax
% function job_view_lf_load_leadfield(inst_id,basisfile)
%
% --- History
% 2009-01-27 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.viewlf{inst_id}.h_fig; 
set(h_fig,'Pointer','watch');

%
% Load lead field data and sensor information
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~exist(basisfile,'file'),
  warndlg(['File ' basisfile ' does not exist.']);
  set(h_fig,'Pointer','arrow');
  return;
end

vbmeg_inst.viewlf{inst_id}.basisfile = basisfile;
basis = vb_load_basis(basisfile);
vbmeg_inst.viewlf{inst_id}.basis_org = (basis*1e-9*1e15)';

% Sensor information
load(basisfile,'basis_parm');
megfile = basis_parm.meg_file;
if iscell(megfile), megfile = megfile{1}; end
if ~exist(megfile), 
  warndlg(['File ' megfile ' does not exist.\n ' ...
           'You can manually load MEG/EEG file, including sensor ' ...
           'information.']);
  uiwait;
  [meg_dir,meg_file] = vb_file_select({'.meg.mat','.eeg.mat'}, ...
                                      'Load MEG/EEG data');
  if ~isempty(meg_file), 
    megfile = [meg_dir filesep meg_file{1}];
  else
    vbmeg_inst.viewlf{inst_id}.basis_org = [];
    set(h_fig,'Pointer','arrow');
    return;
  end
  
  if ~exist(megfile), 
    warndlg(['File ' megfile ' does not exist.\n ']);
    vbmeg_inst.viewlf{inst_id}.basis_org = [];
    set(h_fig,'Pointer','arrow');
    return;
  end
end


vbmeg_inst.viewlf{inst_id}.MEGinfo = vb_load_meg_info(megfile);
pick = vb_load_sensor(megfile);
if size(pick,1)==2*size(vbmeg_inst.viewlf{inst_id}.basis_org,1), 
  pick = pick(1:size(vbmeg_inst.viewlf{inst_id}.basis_org,1),:);
end
vbmeg_inst.viewlf{inst_id}.pick = pick;

job_view_lf_change_filter_radius(inst_id); % Smoothed lead field

%
% Update plots
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_view_lf_update_cortexpattern(inst_id);
job_view_lf_update_sensorpattern(inst_id);
set(h_fig,'Pointer','arrow');

%
% Change figure title
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[tmp,fname,ext] = fileparts(basisfile);
set(h_fig,'Name',['job_view_leadfield: ' fname ext]);
