function job_view_lf_load_cortex(inst_id,brainfile)
% Load cortical surface model
%
% --- Syntax
% function job_view_lf_load_cortex(inst_id,brainfile)
%
% --- History
% 2009-01-27 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

%
% Load cortical surface model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~exist(brainfile),
  warndlg(['File ' brainfile ' does not exist.']);
  return; 
end

vbmeg_inst.viewlf{inst_id}.brainfile = brainfile;

% Cortical surface model
[Vinf,F,xx,inf_C,xxA] = vb_load_cortex(brainfile,'Inflate');

if ~isempty(vbmeg_inst.viewlf{inst_id}.basis_org), 
  if max(size(vbmeg_inst.viewlf{inst_id}.basis_org,2))>size(Vinf,1), 
    warndlg(['Index of dipole currents exceeds the number of ' ...
             'vertices.']);
    return;
  end
end
  
V = vb_load_cortex(brainfile);
vbmeg_inst.viewlf{inst_id}.V = V;
vbmeg_inst.viewlf{inst_id}.Vinf = Vinf;
vbmeg_inst.viewlf{inst_id}.F = F;
vbmeg_inst.viewlf{inst_id}.inf_C = inf_C;
vbmeg_inst.viewlf{inst_id}.xxA = xxA;

% Standard brain coordinate
%load(brainfile,'Vtal','Vmni');
%if ~exist('Vtal','var'), Vtal = zeros(size(V)); end
%if ~exist('Vmni','var'), Vmni = zeros(size(V)); end
%vbmeg_inst.plotcmap{inst_id}.Vtal = Vtal*1e3;
%vbmeg_inst.plotcmap{inst_id}.Vmni = Vmni*1e3;

% Load neighbour data for filter calculation
[nextDD,nextIX] = vb_load_cortex_neighbour(brainfile); 
vbmeg_inst.viewlf{inst_id}.nextDD = nextDD;
vbmeg_inst.viewlf{inst_id}.nextIX = nextIX;

%
% Update plots
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%job_plot_cmap_update_filterradius(inst_id);
job_view_lf_update_cortexpattern(inst_id);
